/*
 * Decompiled with CFR 0.152.
 */
package com.aerospike.client.cluster;

import com.aerospike.client.cluster.Connection;
import com.aerospike.client.cluster.Node;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.locks.ReentrantLock;

public final class Pool {
    private final Connection[] conns;
    private int head;
    private int tail;
    private int size;
    private int minSize;
    private final ReentrantLock lock;
    final AtomicInteger total;

    public Pool(int minSize, int maxSize) {
        this.minSize = minSize;
        this.conns = new Connection[maxSize];
        this.lock = new ReentrantLock(false);
        this.total = new AtomicInteger();
    }

    public int capacity() {
        return this.conns.length;
    }

    public int excess() {
        return this.total.get() - this.minSize;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean offer(Connection conn) {
        if (conn == null) {
            throw new NullPointerException();
        }
        ReentrantLock lock = this.lock;
        lock.lock();
        try {
            if (this.size == this.conns.length) {
                boolean bl = false;
                return bl;
            }
            Connection[] conns = this.conns;
            conns[this.head] = conn;
            if (++this.head == conns.length) {
                this.head = 0;
            }
            ++this.size;
            boolean bl = true;
            return bl;
        }
        finally {
            lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Connection poll() {
        ReentrantLock lock = this.lock;
        lock.lock();
        try {
            if (this.size == 0) {
                Connection connection = null;
                return connection;
            }
            this.head = this.head == 0 ? this.conns.length - 1 : --this.head;
            --this.size;
            Connection[] conns = this.conns;
            Connection conn = conns[this.head];
            conns[this.head] = null;
            Connection connection = conn;
            return connection;
        }
        finally {
            lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void closeIdle(Node node, int count) {
        while (count > 0) {
            Connection conn;
            ReentrantLock lock = this.lock;
            lock.lock();
            try {
                if (this.size == 0) {
                    return;
                }
                Connection[] conns = this.conns;
                conn = conns[this.tail];
                if (conn.isValid()) {
                    return;
                }
                conns[this.tail] = null;
                if (++this.tail == conns.length) {
                    this.tail = 0;
                }
                --this.size;
            }
            finally {
                lock.unlock();
            }
            this.total.getAndDecrement();
            conn.close(node);
            --count;
        }
    }

    public int size() {
        ReentrantLock lock = this.lock;
        lock.lock();
        try {
            int n = this.size;
            return n;
        }
        finally {
            lock.unlock();
        }
    }
}

