/*
 * Decompiled with CFR 0.152.
 */
package com.aerospike.client.command;

import com.aerospike.client.AerospikeException;
import com.aerospike.client.BatchRead;
import com.aerospike.client.Bin;
import com.aerospike.client.Key;
import com.aerospike.client.Log;
import com.aerospike.client.Operation;
import com.aerospike.client.Value;
import com.aerospike.client.command.BatchNode;
import com.aerospike.client.command.Buffer;
import com.aerospike.client.command.OperateArgs;
import com.aerospike.client.policy.BatchPolicy;
import com.aerospike.client.policy.CommitLevel;
import com.aerospike.client.policy.Policy;
import com.aerospike.client.policy.QueryPolicy;
import com.aerospike.client.policy.ReadModeAP;
import com.aerospike.client.policy.ScanPolicy;
import com.aerospike.client.policy.WritePolicy;
import com.aerospike.client.query.Filter;
import com.aerospike.client.query.IndexCollectionType;
import com.aerospike.client.query.PartitionTracker;
import com.aerospike.client.query.PredExp;
import com.aerospike.client.query.Statement;
import com.aerospike.client.util.Packer;
import java.util.List;
import java.util.zip.Deflater;

public abstract class Command {
    public static final int INFO1_READ = 1;
    public static final int INFO1_GET_ALL = 2;
    public static final int INFO1_BATCH = 8;
    public static final int INFO1_NOBINDATA = 32;
    public static final int INFO1_READ_MODE_AP_ALL = 64;
    public static final int INFO1_COMPRESS_RESPONSE = 128;
    public static final int INFO2_WRITE = 1;
    public static final int INFO2_DELETE = 2;
    public static final int INFO2_GENERATION = 4;
    public static final int INFO2_GENERATION_GT = 8;
    public static final int INFO2_DURABLE_DELETE = 16;
    public static final int INFO2_CREATE_ONLY = 32;
    public static final int INFO2_RESPOND_ALL_OPS = 128;
    public static final int INFO3_LAST = 1;
    public static final int INFO3_COMMIT_MASTER = 2;
    public static final int INFO3_PARTITION_DONE = 4;
    public static final int INFO3_UPDATE_ONLY = 8;
    public static final int INFO3_CREATE_OR_REPLACE = 16;
    public static final int INFO3_REPLACE_ONLY = 32;
    public static final int INFO3_SC_READ_TYPE = 64;
    public static final int INFO3_SC_READ_RELAX = 128;
    public static final byte STATE_READ_AUTH_HEADER = 1;
    public static final byte STATE_READ_HEADER = 2;
    public static final byte STATE_READ_DETAIL = 3;
    public static final byte STATE_COMPLETE = 4;
    public static final int MSG_TOTAL_HEADER_SIZE = 30;
    public static final int FIELD_HEADER_SIZE = 5;
    public static final int OPERATION_HEADER_SIZE = 8;
    public static final int MSG_REMAINING_HEADER_SIZE = 22;
    public static final int DIGEST_SIZE = 20;
    public static final int COMPRESS_THRESHOLD = 128;
    public static final long CL_MSG_VERSION = 2L;
    public static final long AS_MSG_TYPE = 3L;
    public static final long MSG_TYPE_COMPRESSED = 4L;
    public byte[] dataBuffer;
    public int dataOffset;
    public final int maxRetries;
    public final int serverTimeout;
    public int socketTimeout;
    public int totalTimeout;

    public Command(int socketTimeout, int totalTimeout, int maxRetries) {
        this.maxRetries = maxRetries;
        this.totalTimeout = totalTimeout;
        if (totalTimeout > 0) {
            this.serverTimeout = this.socketTimeout = socketTimeout < totalTimeout && socketTimeout > 0 ? socketTimeout : totalTimeout;
        } else {
            this.socketTimeout = socketTimeout;
            this.serverTimeout = 0;
        }
    }

    public final void setWrite(WritePolicy policy, Operation.Type operation, Key key, Bin[] bins) throws AerospikeException {
        this.begin();
        int fieldCount = this.estimateKeySize(policy, key);
        int predSize = 0;
        if (policy.predExp != null) {
            predSize = this.estimatePredExp(policy.predExp);
            ++fieldCount;
        }
        for (Bin bin : bins) {
            this.estimateOperationSize(bin);
        }
        this.sizeBuffer();
        this.writeHeaderWrite(policy, 1, fieldCount, bins.length);
        this.writeKey(policy, key);
        if (policy.predExp != null) {
            this.writePredExp(policy.predExp, predSize);
        }
        for (Bin bin : bins) {
            this.writeOperation(bin, operation);
        }
        this.end();
        this.compress(policy);
    }

    public void setDelete(WritePolicy policy, Key key) {
        this.begin();
        int fieldCount = this.estimateKeySize(policy, key);
        int predSize = 0;
        if (policy.predExp != null) {
            predSize = this.estimatePredExp(policy.predExp);
            ++fieldCount;
        }
        this.sizeBuffer();
        this.writeHeaderWrite(policy, 3, fieldCount, 0);
        this.writeKey(policy, key);
        if (policy.predExp != null) {
            this.writePredExp(policy.predExp, predSize);
        }
        this.end();
    }

    public final void setTouch(WritePolicy policy, Key key) {
        this.begin();
        int fieldCount = this.estimateKeySize(policy, key);
        int predSize = 0;
        if (policy.predExp != null) {
            predSize = this.estimatePredExp(policy.predExp);
            ++fieldCount;
        }
        this.estimateOperationSize();
        this.sizeBuffer();
        this.writeHeaderWrite(policy, 1, fieldCount, 1);
        this.writeKey(policy, key);
        if (policy.predExp != null) {
            this.writePredExp(policy.predExp, predSize);
        }
        this.writeOperation(Operation.Type.TOUCH);
        this.end();
    }

    public final void setExists(Policy policy, Key key) {
        this.begin();
        int fieldCount = this.estimateKeySize(policy, key);
        int predSize = 0;
        if (policy.predExp != null) {
            predSize = this.estimatePredExp(policy.predExp);
            ++fieldCount;
        }
        this.sizeBuffer();
        this.writeHeaderReadHeader(policy, 33, fieldCount, 0);
        this.writeKey(policy, key);
        if (policy.predExp != null) {
            this.writePredExp(policy.predExp, predSize);
        }
        this.end();
    }

    private final void setRead(Policy policy, Key key) {
        this.begin();
        int fieldCount = this.estimateKeySize(policy, key);
        int predSize = 0;
        if (policy.predExp != null) {
            predSize = this.estimatePredExp(policy.predExp);
            ++fieldCount;
        }
        this.sizeBuffer();
        this.writeHeaderRead(policy, this.serverTimeout, 3, fieldCount, 0);
        this.writeKey(policy, key);
        if (policy.predExp != null) {
            this.writePredExp(policy.predExp, predSize);
        }
        this.end();
    }

    public final void setRead(Policy policy, Key key, String[] binNames) {
        if (binNames != null) {
            this.begin();
            int fieldCount = this.estimateKeySize(policy, key);
            int predSize = 0;
            if (policy.predExp != null) {
                predSize = this.estimatePredExp(policy.predExp);
                ++fieldCount;
            }
            for (String binName : binNames) {
                this.estimateOperationSize(binName);
            }
            this.sizeBuffer();
            this.writeHeaderRead(policy, this.serverTimeout, 1, fieldCount, binNames.length);
            this.writeKey(policy, key);
            if (policy.predExp != null) {
                this.writePredExp(policy.predExp, predSize);
            }
            for (String binName : binNames) {
                this.writeOperation(binName, Operation.Type.READ);
            }
            this.end();
        } else {
            this.setRead(policy, key);
        }
    }

    public final void setReadHeader(Policy policy, Key key) {
        this.begin();
        int fieldCount = this.estimateKeySize(policy, key);
        int predSize = 0;
        if (policy.predExp != null) {
            predSize = this.estimatePredExp(policy.predExp);
            ++fieldCount;
        }
        this.estimateOperationSize((String)null);
        this.sizeBuffer();
        this.writeHeaderReadHeader(policy, 33, fieldCount, 0);
        this.writeKey(policy, key);
        if (policy.predExp != null) {
            this.writePredExp(policy.predExp, predSize);
        }
        this.end();
    }

    public final void setOperate(WritePolicy policy, Key key, OperateArgs args) {
        this.begin();
        int fieldCount = this.estimateKeySize(policy, key);
        int predSize = 0;
        if (policy.predExp != null) {
            predSize = this.estimatePredExp(policy.predExp);
            ++fieldCount;
        }
        this.dataOffset += args.size;
        this.sizeBuffer();
        this.writeHeaderReadWrite(policy, args.readAttr, args.writeAttr, fieldCount, args.operations.length);
        this.writeKey(policy, key);
        if (policy.predExp != null) {
            this.writePredExp(policy.predExp, predSize);
        }
        for (Operation operation : args.operations) {
            this.writeOperation(operation);
        }
        this.end();
        this.compress(policy);
    }

    public final void setUdf(WritePolicy policy, Key key, String packageName, String functionName, Value[] args) throws AerospikeException {
        this.begin();
        int fieldCount = this.estimateKeySize(policy, key);
        int predSize = 0;
        if (policy.predExp != null) {
            predSize = this.estimatePredExp(policy.predExp);
            ++fieldCount;
        }
        byte[] argBytes = Packer.pack(args);
        this.sizeBuffer();
        this.writeHeaderWrite(policy, 1, fieldCount += this.estimateUdfSize(packageName, functionName, argBytes), 0);
        this.writeKey(policy, key);
        if (policy.predExp != null) {
            this.writePredExp(policy.predExp, predSize);
        }
        this.writeField(packageName, 30);
        this.writeField(functionName, 31);
        this.writeField(argBytes, 32);
        this.end();
        this.compress(policy);
    }

    public final void setBatchRead(BatchPolicy policy, List<BatchRead> records, BatchNode batch) {
        int[] offsets = batch.offsets;
        int max = batch.offsetsSize;
        int fieldCountRow = policy.sendSetName ? 2 : 1;
        BatchRead prev = null;
        this.begin();
        int fieldCount = 1;
        int predSize = 0;
        if (policy.predExp != null) {
            predSize = this.estimatePredExp(policy.predExp);
            ++fieldCount;
        }
        this.dataOffset += 10;
        for (int i = 0; i < max; ++i) {
            BatchRead record = records.get(offsets[i]);
            Key key = record.key;
            String[] binNames = record.binNames;
            this.dataOffset += key.digest.length + 4;
            if (!(prev == null || prev.key.namespace != key.namespace || policy.sendSetName && prev.key.setName != key.setName || prev.binNames != binNames || prev.readAllBins != record.readAllBins)) {
                ++this.dataOffset;
                continue;
            }
            this.dataOffset += Buffer.estimateSizeUtf8(key.namespace) + 5 + 6;
            if (policy.sendSetName) {
                this.dataOffset += Buffer.estimateSizeUtf8(key.setName) + 5;
            }
            if (binNames != null) {
                for (String binName : binNames) {
                    this.estimateOperationSize(binName);
                }
            }
            prev = record;
        }
        this.sizeBuffer();
        int readAttr = 1;
        if (policy.readModeAP == ReadModeAP.ALL) {
            readAttr |= 0x40;
        }
        this.writeHeaderRead(policy, this.totalTimeout, readAttr | 8, fieldCount, 0);
        if (policy.predExp != null) {
            this.writePredExp(policy.predExp, predSize);
        }
        int fieldSizeOffset = this.dataOffset;
        this.writeFieldHeader(0, policy.sendSetName ? 42 : 41);
        Buffer.intToBytes(max, this.dataBuffer, this.dataOffset);
        this.dataOffset += 4;
        this.dataBuffer[this.dataOffset++] = policy.allowInline ? (byte)1 : 0;
        prev = null;
        for (int i = 0; i < max; ++i) {
            int index2 = offsets[i];
            Buffer.intToBytes(index2, this.dataBuffer, this.dataOffset);
            this.dataOffset += 4;
            BatchRead record = records.get(index2);
            Key key = record.key;
            String[] binNames = record.binNames;
            byte[] digest = key.digest;
            System.arraycopy(digest, 0, this.dataBuffer, this.dataOffset, digest.length);
            this.dataOffset += digest.length;
            if (!(prev == null || prev.key.namespace != key.namespace || policy.sendSetName && prev.key.setName != key.setName || prev.binNames != binNames || prev.readAllBins != record.readAllBins)) {
                this.dataBuffer[this.dataOffset++] = 1;
                continue;
            }
            this.dataBuffer[this.dataOffset++] = 0;
            if (binNames != null && binNames.length != 0) {
                this.dataBuffer[this.dataOffset++] = (byte)readAttr;
                Buffer.shortToBytes(fieldCountRow, this.dataBuffer, this.dataOffset);
                this.dataOffset += 2;
                Buffer.shortToBytes(binNames.length, this.dataBuffer, this.dataOffset);
                this.dataOffset += 2;
                this.writeField(key.namespace, 0);
                if (policy.sendSetName) {
                    this.writeField(key.setName, 1);
                }
                for (String binName : binNames) {
                    this.writeOperation(binName, Operation.Type.READ);
                }
            } else {
                this.dataBuffer[this.dataOffset++] = (byte)(readAttr | (record.readAllBins ? 2 : 32));
                Buffer.shortToBytes(fieldCountRow, this.dataBuffer, this.dataOffset);
                this.dataOffset += 2;
                Buffer.shortToBytes(0, this.dataBuffer, this.dataOffset);
                this.dataOffset += 2;
                this.writeField(key.namespace, 0);
                if (policy.sendSetName) {
                    this.writeField(key.setName, 1);
                }
            }
            prev = record;
        }
        Buffer.intToBytes(this.dataOffset - 30 - 4, this.dataBuffer, fieldSizeOffset);
        this.end();
        this.compress(policy);
    }

    public final void setBatchRead(BatchPolicy policy, Key[] keys, BatchNode batch, String[] binNames, int readAttr) {
        int[] offsets = batch.offsets;
        int max = batch.offsetsSize;
        int fieldCountRow = policy.sendSetName ? 2 : 1;
        int binNameSize = 0;
        int operationCount = 0;
        if (binNames != null) {
            for (String binName : binNames) {
                binNameSize += Buffer.estimateSizeUtf8(binName) + 8;
            }
            operationCount = binNames.length;
        }
        this.begin();
        int fieldCount = 1;
        int predSize = 0;
        if (policy.predExp != null) {
            predSize = this.estimatePredExp(policy.predExp);
            ++fieldCount;
        }
        this.dataOffset += 10;
        Key prev = null;
        for (int i = 0; i < max; ++i) {
            Key key = keys[offsets[i]];
            this.dataOffset += key.digest.length + 4;
            if (!(prev == null || prev.namespace != key.namespace || policy.sendSetName && prev.setName != key.setName)) {
                ++this.dataOffset;
                continue;
            }
            this.dataOffset += Buffer.estimateSizeUtf8(key.namespace) + 5 + 6;
            if (policy.sendSetName) {
                this.dataOffset += Buffer.estimateSizeUtf8(key.setName) + 5;
            }
            this.dataOffset += binNameSize;
            prev = key;
        }
        this.sizeBuffer();
        if (policy.readModeAP == ReadModeAP.ALL) {
            readAttr |= 0x40;
        }
        this.writeHeaderRead(policy, this.totalTimeout, readAttr | 8, fieldCount, 0);
        if (policy.predExp != null) {
            this.writePredExp(policy.predExp, predSize);
        }
        int fieldSizeOffset = this.dataOffset;
        this.writeFieldHeader(0, policy.sendSetName ? 42 : 41);
        Buffer.intToBytes(max, this.dataBuffer, this.dataOffset);
        this.dataOffset += 4;
        this.dataBuffer[this.dataOffset++] = policy.allowInline ? (byte)1 : 0;
        prev = null;
        for (int i = 0; i < max; ++i) {
            int index2 = offsets[i];
            Buffer.intToBytes(index2, this.dataBuffer, this.dataOffset);
            this.dataOffset += 4;
            Key key = keys[index2];
            byte[] digest = key.digest;
            System.arraycopy(digest, 0, this.dataBuffer, this.dataOffset, digest.length);
            this.dataOffset += digest.length;
            if (!(prev == null || prev.namespace != key.namespace || policy.sendSetName && prev.setName != key.setName)) {
                this.dataBuffer[this.dataOffset++] = 1;
                continue;
            }
            this.dataBuffer[this.dataOffset++] = 0;
            this.dataBuffer[this.dataOffset++] = (byte)readAttr;
            Buffer.shortToBytes(fieldCountRow, this.dataBuffer, this.dataOffset);
            this.dataOffset += 2;
            Buffer.shortToBytes(operationCount, this.dataBuffer, this.dataOffset);
            this.dataOffset += 2;
            this.writeField(key.namespace, 0);
            if (policy.sendSetName) {
                this.writeField(key.setName, 1);
            }
            if (binNames != null) {
                for (String binName : binNames) {
                    this.writeOperation(binName, Operation.Type.READ);
                }
            }
            prev = key;
        }
        Buffer.intToBytes(this.dataOffset - 30 - 4, this.dataBuffer, fieldSizeOffset);
        this.end();
        this.compress(policy);
    }

    public final void setScan(ScanPolicy policy, String namespace, String setName, String[] binNames, long taskId, PartitionTracker.NodePartitions nodePartitions) {
        this.begin();
        int fieldCount = 0;
        int partsFullSize = 0;
        int partsPartialSize = 0;
        long maxRecords = 0L;
        if (nodePartitions != null) {
            partsFullSize = nodePartitions.partsFull.size() * 2;
            partsPartialSize = nodePartitions.partsPartial.size() * 20;
            maxRecords = nodePartitions.recordMax;
        }
        if (namespace != null) {
            this.dataOffset += Buffer.estimateSizeUtf8(namespace) + 5;
            ++fieldCount;
        }
        if (setName != null) {
            this.dataOffset += Buffer.estimateSizeUtf8(setName) + 5;
            ++fieldCount;
        }
        if (partsFullSize > 0) {
            this.dataOffset += partsFullSize + 5;
            ++fieldCount;
        }
        if (partsPartialSize > 0) {
            this.dataOffset += partsPartialSize + 5;
            ++fieldCount;
        }
        if (maxRecords > 0L) {
            this.dataOffset += 13;
            ++fieldCount;
        }
        if (policy.recordsPerSecond > 0) {
            this.dataOffset += 9;
            ++fieldCount;
        }
        int predSize = 0;
        if (policy.predExp != null) {
            predSize = this.estimatePredExp(policy.predExp);
            ++fieldCount;
        }
        if (nodePartitions == null) {
            this.dataOffset += 7;
            ++fieldCount;
        }
        this.dataOffset += 9;
        ++fieldCount;
        this.dataOffset += 13;
        ++fieldCount;
        if (binNames != null) {
            for (String binName : binNames) {
                this.estimateOperationSize(binName);
            }
        }
        this.sizeBuffer();
        int readAttr = 1;
        if (!policy.includeBinData) {
            readAttr = (byte)(readAttr | 0x20);
        }
        int operationCount = binNames == null ? 0 : binNames.length;
        this.writeHeaderRead(policy, this.totalTimeout, readAttr, fieldCount, operationCount);
        if (namespace != null) {
            this.writeField(namespace, 0);
        }
        if (setName != null) {
            this.writeField(setName, 1);
        }
        if (partsFullSize > 0) {
            this.writeFieldHeader(partsFullSize, 11);
            for (PartitionTracker.PartitionStatus part : nodePartitions.partsFull) {
                Buffer.shortToLittleBytes(part.id, this.dataBuffer, this.dataOffset);
                this.dataOffset += 2;
            }
        }
        if (partsPartialSize > 0) {
            this.writeFieldHeader(partsPartialSize, 12);
            for (PartitionTracker.PartitionStatus part : nodePartitions.partsPartial) {
                System.arraycopy(part.digest, 0, this.dataBuffer, this.dataOffset, 20);
                this.dataOffset += 20;
            }
        }
        if (maxRecords > 0L) {
            this.writeField(maxRecords, 13);
        }
        if (policy.recordsPerSecond > 0) {
            this.writeField(policy.recordsPerSecond, 10);
        }
        if (policy.predExp != null) {
            this.writePredExp(policy.predExp, predSize);
        }
        if (nodePartitions == null) {
            this.writeFieldHeader(2, 8);
            byte priority = (byte)policy.priority.ordinal();
            priority = (byte)(priority << 4);
            if (policy.failOnClusterChange) {
                priority = (byte)(priority | 8);
            }
            this.dataBuffer[this.dataOffset++] = priority;
            this.dataBuffer[this.dataOffset++] = (byte)policy.scanPercent;
        }
        this.writeField(policy.socketTimeout, 9);
        this.writeField(taskId, 7);
        if (binNames != null) {
            for (String binName : binNames) {
                this.writeOperation(binName, Operation.Type.READ);
            }
        }
        this.end();
    }

    public final void setQuery(Policy policy, Statement statement, boolean write2, PartitionTracker.NodePartitions nodePartitions) {
        int n;
        int n2;
        byte[] functionArgBuffer = null;
        int fieldCount = 0;
        int filterSize = 0;
        int binNameSize = 0;
        int partsFullSize = 0;
        int partsPartialSize = 0;
        long maxRecords = 0L;
        this.begin();
        if (statement.getNamespace() != null) {
            this.dataOffset += Buffer.estimateSizeUtf8(statement.getNamespace()) + 5;
            ++fieldCount;
        }
        if (statement.getIndexName() != null) {
            this.dataOffset += Buffer.estimateSizeUtf8(statement.getIndexName()) + 5;
            ++fieldCount;
        }
        if (statement.getSetName() != null) {
            this.dataOffset += Buffer.estimateSizeUtf8(statement.getSetName()) + 5;
            ++fieldCount;
        }
        this.dataOffset += 13;
        ++fieldCount;
        Filter filter = statement.getFilter();
        String[] binNames = statement.getBinNames();
        if (filter != null) {
            IndexCollectionType type = filter.getCollectionType();
            if (type != IndexCollectionType.DEFAULT) {
                this.dataOffset += 6;
                ++fieldCount;
            }
            this.dataOffset += 5;
            ++filterSize;
            this.dataOffset += (filterSize += filter.estimateSize());
            ++fieldCount;
            if (binNames != null && binNames.length > 0) {
                this.dataOffset += 5;
                ++binNameSize;
                for (String string : binNames) {
                    binNameSize += Buffer.estimateSizeUtf8(string) + 1;
                }
                this.dataOffset += binNameSize;
                ++fieldCount;
            }
        } else {
            if (nodePartitions != null) {
                partsFullSize = nodePartitions.partsFull.size() * 2;
                partsPartialSize = nodePartitions.partsPartial.size() * 20;
                maxRecords = nodePartitions.recordMax;
            }
            if (partsFullSize > 0) {
                this.dataOffset += partsFullSize + 5;
                ++fieldCount;
            }
            if (partsPartialSize > 0) {
                this.dataOffset += partsPartialSize + 5;
                ++fieldCount;
            }
            if (maxRecords > 0L) {
                this.dataOffset += 13;
                ++fieldCount;
            }
            if (nodePartitions == null) {
                this.dataOffset += 7;
                ++fieldCount;
            }
            this.dataOffset += 9;
            ++fieldCount;
            if (statement.getRecordsPerSecond() > 0) {
                this.dataOffset += 9;
                ++fieldCount;
            }
        }
        PredExp[] predExp = statement.getPredExp();
        int predSize = 0;
        if (policy.predExp != null && predExp == null) {
            predExp = policy.predExp;
        }
        if (predExp != null) {
            predSize = this.estimatePredExp(predExp);
            ++fieldCount;
        }
        if (statement.getFunctionName() != null) {
            this.dataOffset += 6;
            this.dataOffset += Buffer.estimateSizeUtf8(statement.getPackageName()) + 5;
            this.dataOffset += Buffer.estimateSizeUtf8(statement.getFunctionName()) + 5;
            functionArgBuffer = statement.getFunctionArgs().length > 0 ? Packer.pack(statement.getFunctionArgs()) : new byte[]{};
            this.dataOffset += 5 + functionArgBuffer.length;
            fieldCount += 4;
        }
        Operation[] operations = statement.getOperations();
        int operationCount = 0;
        if (operations != null) {
            Operation[] operationArray = operations;
            n2 = operationArray.length;
            for (n = 0; n < n2; ++n) {
                Operation operation = operationArray[n];
                this.estimateOperationSize(operation);
            }
            operationCount = operations.length;
        } else if (binNames != null && filter == null) {
            String[] stringArray = binNames;
            n2 = stringArray.length;
            for (n = 0; n < n2; ++n) {
                String binName3 = stringArray[n];
                this.estimateOperationSize(binName3);
            }
            operationCount = binNames.length;
        }
        this.sizeBuffer();
        if (write2) {
            this.writeHeaderWrite((WritePolicy)policy, 1, fieldCount, operationCount);
        } else {
            QueryPolicy queryPolicy = (QueryPolicy)policy;
            int readAttr = queryPolicy.includeBinData ? 1 : 33;
            this.writeHeaderRead(policy, this.totalTimeout, readAttr, fieldCount, operationCount);
        }
        if (statement.getNamespace() != null) {
            this.writeField(statement.getNamespace(), 0);
        }
        if (statement.getIndexName() != null) {
            this.writeField(statement.getIndexName(), 21);
        }
        if (statement.getSetName() != null) {
            this.writeField(statement.getSetName(), 1);
        }
        this.writeField(statement.getTaskId(), 7);
        if (filter != null) {
            IndexCollectionType indexCollectionType = filter.getCollectionType();
            if (indexCollectionType != IndexCollectionType.DEFAULT) {
                this.writeFieldHeader(1, 26);
                this.dataBuffer[this.dataOffset++] = (byte)indexCollectionType.ordinal();
            }
            this.writeFieldHeader(filterSize, 22);
            this.dataBuffer[this.dataOffset++] = 1;
            this.dataOffset = filter.write(this.dataBuffer, this.dataOffset);
            if (binNames != null && binNames.length > 0) {
                this.writeFieldHeader(binNameSize, 40);
                this.dataBuffer[this.dataOffset++] = (byte)binNames.length;
                String[] readAttr = binNames;
                n = readAttr.length;
                for (int binName3 = 0; binName3 < n; ++binName3) {
                    String binName4 = readAttr[binName3];
                    int len = Buffer.stringToUtf8(binName4, this.dataBuffer, this.dataOffset + 1);
                    this.dataBuffer[this.dataOffset] = (byte)len;
                    this.dataOffset += len + 1;
                }
            }
        } else {
            if (partsFullSize > 0) {
                this.writeFieldHeader(partsFullSize, 11);
                for (PartitionTracker.PartitionStatus part : nodePartitions.partsFull) {
                    Buffer.shortToLittleBytes(part.id, this.dataBuffer, this.dataOffset);
                    this.dataOffset += 2;
                }
            }
            if (partsPartialSize > 0) {
                this.writeFieldHeader(partsPartialSize, 12);
                for (PartitionTracker.PartitionStatus part : nodePartitions.partsPartial) {
                    System.arraycopy(part.digest, 0, this.dataBuffer, this.dataOffset, 20);
                    this.dataOffset += 20;
                }
            }
            if (maxRecords > 0L) {
                this.writeField(maxRecords, 13);
            }
            if (nodePartitions == null) {
                byte by;
                this.writeFieldHeader(2, 8);
                byte by3 = (byte)policy.priority.ordinal();
                by3 = (byte)(by3 << 4);
                if (!write2 && ((QueryPolicy)policy).failOnClusterChange) {
                    by = (byte)(by3 | 8);
                }
                this.dataBuffer[this.dataOffset++] = by;
                this.dataBuffer[this.dataOffset++] = 100;
            }
            this.writeField(policy.socketTimeout, 9);
            if (statement.getRecordsPerSecond() > 0) {
                this.writeField(statement.getRecordsPerSecond(), 10);
            }
        }
        if (predExp != null) {
            this.writePredExp(predExp, predSize);
        }
        if (statement.getFunctionName() != null) {
            this.writeFieldHeader(1, 33);
            this.dataBuffer[this.dataOffset++] = statement.returnData() ? 1 : 2;
            this.writeField(statement.getPackageName(), 30);
            this.writeField(statement.getFunctionName(), 31);
            this.writeField(functionArgBuffer, 32);
        }
        if (operations != null) {
            for (Operation operation : operations) {
                this.writeOperation(operation);
            }
        } else if (binNames != null && filter == null) {
            for (String binName5 : binNames) {
                this.writeOperation(binName5, Operation.Type.READ);
            }
        }
        this.end();
    }

    private final int estimateKeySize(Policy policy, Key key) {
        int fieldCount = 0;
        if (key.namespace != null) {
            this.dataOffset += Buffer.estimateSizeUtf8(key.namespace) + 5;
            ++fieldCount;
        }
        if (key.setName != null) {
            this.dataOffset += Buffer.estimateSizeUtf8(key.setName) + 5;
            ++fieldCount;
        }
        this.dataOffset += key.digest.length + 5;
        ++fieldCount;
        if (policy.sendKey) {
            this.dataOffset += key.userKey.estimateSize() + 5 + 1;
            ++fieldCount;
        }
        return fieldCount;
    }

    private final int estimateUdfSize(String packageName, String functionName, byte[] bytes) {
        this.dataOffset += Buffer.estimateSizeUtf8(packageName) + 5;
        this.dataOffset += Buffer.estimateSizeUtf8(functionName) + 5;
        this.dataOffset += bytes.length + 5;
        return 3;
    }

    private final int estimatePredExp(PredExp[] predExp) {
        int sz = PredExp.estimateSize(predExp);
        this.dataOffset += sz + 5;
        return sz;
    }

    private final void estimateOperationSize(Bin bin) throws AerospikeException {
        this.dataOffset += Buffer.estimateSizeUtf8(bin.name) + 8;
        this.dataOffset += bin.value.estimateSize();
    }

    private final void estimateOperationSize(Operation operation) throws AerospikeException {
        this.dataOffset += Buffer.estimateSizeUtf8(operation.binName) + 8;
        this.dataOffset += operation.value.estimateSize();
    }

    private final void estimateOperationSize(String binName) {
        this.dataOffset += Buffer.estimateSizeUtf8(binName) + 8;
    }

    private final void estimateOperationSize() {
        this.dataOffset += 8;
    }

    private final void writeHeaderWrite(WritePolicy policy, int writeAttr, int fieldCount, int operationCount) {
        int generation = 0;
        int infoAttr = 0;
        switch (policy.recordExistsAction) {
            case UPDATE: {
                break;
            }
            case UPDATE_ONLY: {
                infoAttr |= 8;
                break;
            }
            case REPLACE: {
                infoAttr |= 0x10;
                break;
            }
            case REPLACE_ONLY: {
                infoAttr |= 0x20;
                break;
            }
            case CREATE_ONLY: {
                writeAttr |= 0x20;
            }
        }
        switch (policy.generationPolicy) {
            case NONE: {
                break;
            }
            case EXPECT_GEN_EQUAL: {
                generation = policy.generation;
                writeAttr |= 4;
                break;
            }
            case EXPECT_GEN_GT: {
                generation = policy.generation;
                writeAttr |= 8;
            }
        }
        if (policy.commitLevel == CommitLevel.COMMIT_MASTER) {
            infoAttr |= 2;
        }
        if (policy.durableDelete) {
            writeAttr |= 0x10;
        }
        this.dataBuffer[8] = 22;
        this.dataBuffer[9] = 0;
        this.dataBuffer[10] = (byte)writeAttr;
        this.dataBuffer[11] = (byte)infoAttr;
        this.dataBuffer[12] = 0;
        this.dataBuffer[13] = 0;
        Buffer.intToBytes(generation, this.dataBuffer, 14);
        Buffer.intToBytes(policy.expiration, this.dataBuffer, 18);
        Buffer.intToBytes(this.serverTimeout, this.dataBuffer, 22);
        Buffer.shortToBytes(fieldCount, this.dataBuffer, 26);
        Buffer.shortToBytes(operationCount, this.dataBuffer, 28);
        this.dataOffset = 30;
    }

    private final void writeHeaderReadWrite(WritePolicy policy, int readAttr, int writeAttr, int fieldCount, int operationCount) {
        int generation = 0;
        int infoAttr = 0;
        switch (policy.recordExistsAction) {
            case UPDATE: {
                break;
            }
            case UPDATE_ONLY: {
                infoAttr |= 8;
                break;
            }
            case REPLACE: {
                infoAttr |= 0x10;
                break;
            }
            case REPLACE_ONLY: {
                infoAttr |= 0x20;
                break;
            }
            case CREATE_ONLY: {
                writeAttr |= 0x20;
            }
        }
        switch (policy.generationPolicy) {
            case NONE: {
                break;
            }
            case EXPECT_GEN_EQUAL: {
                generation = policy.generation;
                writeAttr |= 4;
                break;
            }
            case EXPECT_GEN_GT: {
                generation = policy.generation;
                writeAttr |= 8;
            }
        }
        if (policy.commitLevel == CommitLevel.COMMIT_MASTER) {
            infoAttr |= 2;
        }
        if (policy.durableDelete) {
            writeAttr |= 0x10;
        }
        switch (policy.readModeSC) {
            case SESSION: {
                break;
            }
            case LINEARIZE: {
                infoAttr |= 0x40;
                break;
            }
            case ALLOW_REPLICA: {
                infoAttr |= 0x80;
                break;
            }
            case ALLOW_UNAVAILABLE: {
                infoAttr |= 0xC0;
            }
        }
        if (policy.readModeAP == ReadModeAP.ALL) {
            readAttr |= 0x40;
        }
        if (policy.compress) {
            readAttr |= 0x80;
        }
        this.dataBuffer[8] = 22;
        this.dataBuffer[9] = (byte)readAttr;
        this.dataBuffer[10] = (byte)writeAttr;
        this.dataBuffer[11] = (byte)infoAttr;
        this.dataBuffer[12] = 0;
        this.dataBuffer[13] = 0;
        Buffer.intToBytes(generation, this.dataBuffer, 14);
        Buffer.intToBytes(policy.expiration, this.dataBuffer, 18);
        Buffer.intToBytes(this.serverTimeout, this.dataBuffer, 22);
        Buffer.shortToBytes(fieldCount, this.dataBuffer, 26);
        Buffer.shortToBytes(operationCount, this.dataBuffer, 28);
        this.dataOffset = 30;
    }

    private final void writeHeaderRead(Policy policy, int timeout, int readAttr, int fieldCount, int operationCount) {
        int infoAttr = 0;
        switch (policy.readModeSC) {
            case SESSION: {
                break;
            }
            case LINEARIZE: {
                infoAttr |= 0x40;
                break;
            }
            case ALLOW_REPLICA: {
                infoAttr |= 0x80;
                break;
            }
            case ALLOW_UNAVAILABLE: {
                infoAttr |= 0xC0;
            }
        }
        if (policy.readModeAP == ReadModeAP.ALL) {
            readAttr |= 0x40;
        }
        if (policy.compress) {
            readAttr |= 0x80;
        }
        this.dataBuffer[8] = 22;
        this.dataBuffer[9] = (byte)readAttr;
        this.dataBuffer[10] = 0;
        this.dataBuffer[11] = (byte)infoAttr;
        for (int i = 12; i < 22; ++i) {
            this.dataBuffer[i] = 0;
        }
        Buffer.intToBytes(timeout, this.dataBuffer, 22);
        Buffer.shortToBytes(fieldCount, this.dataBuffer, 26);
        Buffer.shortToBytes(operationCount, this.dataBuffer, 28);
        this.dataOffset = 30;
    }

    private final void writeHeaderReadHeader(Policy policy, int readAttr, int fieldCount, int operationCount) {
        int infoAttr = 0;
        switch (policy.readModeSC) {
            case SESSION: {
                break;
            }
            case LINEARIZE: {
                infoAttr |= 0x40;
                break;
            }
            case ALLOW_REPLICA: {
                infoAttr |= 0x80;
                break;
            }
            case ALLOW_UNAVAILABLE: {
                infoAttr |= 0xC0;
            }
        }
        if (policy.readModeAP == ReadModeAP.ALL) {
            readAttr |= 0x40;
        }
        this.dataBuffer[8] = 22;
        this.dataBuffer[9] = (byte)readAttr;
        this.dataBuffer[10] = 0;
        this.dataBuffer[11] = (byte)infoAttr;
        for (int i = 12; i < 22; ++i) {
            this.dataBuffer[i] = 0;
        }
        Buffer.intToBytes(this.serverTimeout, this.dataBuffer, 22);
        Buffer.shortToBytes(fieldCount, this.dataBuffer, 26);
        Buffer.shortToBytes(operationCount, this.dataBuffer, 28);
        this.dataOffset = 30;
    }

    private final void writeKey(Policy policy, Key key) {
        if (key.namespace != null) {
            this.writeField(key.namespace, 0);
        }
        if (key.setName != null) {
            this.writeField(key.setName, 1);
        }
        this.writeField(key.digest, 4);
        if (policy.sendKey) {
            this.writeField(key.userKey, 2);
        }
    }

    private final void writePredExp(PredExp[] predExp, int predSize) {
        this.writeFieldHeader(predSize, 43);
        this.dataOffset = PredExp.write(predExp, this.dataBuffer, this.dataOffset);
    }

    private final void writeOperation(Bin bin, Operation.Type operation) throws AerospikeException {
        int nameLength = Buffer.stringToUtf8(bin.name, this.dataBuffer, this.dataOffset + 8);
        int valueLength = bin.value.write(this.dataBuffer, this.dataOffset + 8 + nameLength);
        Buffer.intToBytes(nameLength + valueLength + 4, this.dataBuffer, this.dataOffset);
        this.dataOffset += 4;
        this.dataBuffer[this.dataOffset++] = (byte)operation.protocolType;
        this.dataBuffer[this.dataOffset++] = (byte)bin.value.getType();
        this.dataBuffer[this.dataOffset++] = 0;
        this.dataBuffer[this.dataOffset++] = (byte)nameLength;
        this.dataOffset += nameLength + valueLength;
    }

    private final void writeOperation(Operation operation) throws AerospikeException {
        int nameLength = Buffer.stringToUtf8(operation.binName, this.dataBuffer, this.dataOffset + 8);
        int valueLength = operation.value.write(this.dataBuffer, this.dataOffset + 8 + nameLength);
        Buffer.intToBytes(nameLength + valueLength + 4, this.dataBuffer, this.dataOffset);
        this.dataOffset += 4;
        this.dataBuffer[this.dataOffset++] = (byte)operation.type.protocolType;
        this.dataBuffer[this.dataOffset++] = (byte)operation.value.getType();
        this.dataBuffer[this.dataOffset++] = 0;
        this.dataBuffer[this.dataOffset++] = (byte)nameLength;
        this.dataOffset += nameLength + valueLength;
    }

    private final void writeOperation(String name, Operation.Type operation) {
        int nameLength = Buffer.stringToUtf8(name, this.dataBuffer, this.dataOffset + 8);
        Buffer.intToBytes(nameLength + 4, this.dataBuffer, this.dataOffset);
        this.dataOffset += 4;
        this.dataBuffer[this.dataOffset++] = (byte)operation.protocolType;
        this.dataBuffer[this.dataOffset++] = 0;
        this.dataBuffer[this.dataOffset++] = 0;
        this.dataBuffer[this.dataOffset++] = (byte)nameLength;
        this.dataOffset += nameLength;
    }

    private final void writeOperation(Operation.Type operation) {
        Buffer.intToBytes(4, this.dataBuffer, this.dataOffset);
        this.dataOffset += 4;
        this.dataBuffer[this.dataOffset++] = (byte)operation.protocolType;
        this.dataBuffer[this.dataOffset++] = 0;
        this.dataBuffer[this.dataOffset++] = 0;
        this.dataBuffer[this.dataOffset++] = 0;
    }

    private final void writeField(Value value, int type) throws AerospikeException {
        int offset = this.dataOffset + 5;
        this.dataBuffer[offset++] = (byte)value.getType();
        int len = value.write(this.dataBuffer, offset) + 1;
        this.writeFieldHeader(len, type);
        this.dataOffset += len;
    }

    private final void writeField(String str, int type) {
        int len = Buffer.stringToUtf8(str, this.dataBuffer, this.dataOffset + 5);
        this.writeFieldHeader(len, type);
        this.dataOffset += len;
    }

    private final void writeField(byte[] bytes, int type) {
        System.arraycopy(bytes, 0, this.dataBuffer, this.dataOffset + 5, bytes.length);
        this.writeFieldHeader(bytes.length, type);
        this.dataOffset += bytes.length;
    }

    private final void writeField(int val, int type) {
        this.writeFieldHeader(4, type);
        Buffer.intToBytes(val, this.dataBuffer, this.dataOffset);
        this.dataOffset += 4;
    }

    private final void writeField(long val, int type) {
        this.writeFieldHeader(8, type);
        Buffer.longToBytes(val, this.dataBuffer, this.dataOffset);
        this.dataOffset += 8;
    }

    private final void writeFieldHeader(int size, int type) {
        Buffer.intToBytes(size + 1, this.dataBuffer, this.dataOffset);
        this.dataOffset += 4;
        this.dataBuffer[this.dataOffset++] = (byte)type;
    }

    private final void begin() {
        this.dataOffset = 30;
    }

    private final void end() {
        long proto = (long)(this.dataOffset - 8) | 0x200000000000000L | 0x3000000000000L;
        Buffer.longToBytes(proto, this.dataBuffer, 0);
    }

    private final void compress(Policy policy) {
        if (policy.compress && this.dataOffset > 128) {
            Deflater def = new Deflater();
            def.setLevel(1);
            def.setInput(this.dataBuffer, 0, this.dataOffset);
            def.finish();
            byte[] cbuf = new byte[this.dataOffset];
            int csize = def.deflate(cbuf, 16, this.dataOffset - 16);
            if (def.finished()) {
                long proto = (long)(csize + 8) | 0x200000000000000L | 0x4000000000000L;
                Buffer.longToBytes(proto, cbuf, 0);
                Buffer.longToBytes(this.dataOffset, cbuf, 8);
                this.dataBuffer = cbuf;
                this.dataOffset = csize + 16;
            }
        }
    }

    public static void LogPolicy(Policy p) {
        Log.debug("Policy: socketTimeout=" + p.socketTimeout + " totalTimeout=" + p.totalTimeout + " maxRetries=" + p.maxRetries + " sleepBetweenRetries=" + p.sleepBetweenRetries);
    }

    protected final Key parseKey(int fieldCount) {
        byte[] digest = null;
        String namespace = null;
        String setName = null;
        Value userKey = null;
        for (int i = 0; i < fieldCount; ++i) {
            int fieldlen = Buffer.bytesToInt(this.dataBuffer, this.dataOffset);
            this.dataOffset += 4;
            byte fieldtype = this.dataBuffer[this.dataOffset++];
            int size = fieldlen - 1;
            switch (fieldtype) {
                case 4: {
                    digest = new byte[size];
                    System.arraycopy(this.dataBuffer, this.dataOffset, digest, 0, size);
                    break;
                }
                case 0: {
                    namespace = Buffer.utf8ToString(this.dataBuffer, this.dataOffset, size);
                    break;
                }
                case 1: {
                    setName = Buffer.utf8ToString(this.dataBuffer, this.dataOffset, size);
                    break;
                }
                case 2: {
                    byte type = this.dataBuffer[this.dataOffset++];
                    userKey = Buffer.bytesToKeyValue(type, this.dataBuffer, this.dataOffset, --size);
                }
            }
            this.dataOffset += size;
        }
        return new Key(namespace, digest, setName, userKey);
    }

    protected abstract void sizeBuffer();
}

