/*
 * Decompiled with CFR 0.152.
 */
package com.aerospike.client.util;

import com.aerospike.client.AerospikeException;
import java.io.ByteArrayOutputStream;
import java.io.EOFException;
import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.math.BigInteger;
import java.net.SocketException;
import java.net.SocketTimeoutException;
import java.net.URL;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;

public final class Util {
    public static void sleep(long millis) {
        try {
            Thread.sleep(millis);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }

    public static String getErrorMessage(Exception e) {
        Throwable cause = e.getCause();
        if (e instanceof SocketException || e instanceof AerospikeException.Connection || cause instanceof SocketTimeoutException) {
            return e.getMessage();
        }
        if (e instanceof EOFException || cause instanceof EOFException) {
            return EOFException.class.getName();
        }
        StringWriter sw = new StringWriter(1000);
        PrintWriter pw = new PrintWriter(sw);
        e.printStackTrace(pw);
        return sw.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static byte[] readFile(File file) {
        byte[] byArray;
        byte[] bytes = new byte[(int)file.length()];
        FileInputStream in = new FileInputStream(file);
        try {
            int len = 0;
            for (int pos = 0; pos < bytes.length; pos += len) {
                len = in.read(bytes, pos, bytes.length - pos);
            }
            byArray = bytes;
        }
        catch (Throwable throwable) {
            try {
                in.close();
                throw throwable;
            }
            catch (Exception e) {
                throw new AerospikeException("Failed to read " + file.getAbsolutePath(), (Throwable)e);
            }
        }
        in.close();
        return byArray;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static byte[] readResource(ClassLoader resourceLoader, String resourcePath) {
        byte[] byArray;
        URL url = resourceLoader.getResource(resourcePath);
        if (url == null) {
            throw new IllegalArgumentException("Resource: " + resourcePath + " not found");
        }
        InputStream is = url.openStream();
        try {
            int length;
            ByteArrayOutputStream bos = new ByteArrayOutputStream(8192);
            byte[] bytes = new byte[8192];
            while ((length = is.read(bytes)) > 0) {
                bos.write(bytes, 0, length);
            }
            byArray = bos.toByteArray();
        }
        catch (Throwable throwable) {
            try {
                is.close();
                throw throwable;
            }
            catch (Exception e) {
                throw new AerospikeException("Failed to read resource " + resourcePath, (Throwable)e);
            }
        }
        is.close();
        return byArray;
    }

    public static BigInteger[] toBigIntegerArray(String str) {
        String[] strArray = str.split(",");
        BigInteger[] bigArray = new BigInteger[strArray.length];
        int count = 0;
        for (String s : strArray) {
            if (s.startsWith("0x")) {
                bigArray[count] = new BigInteger(s.substring(2), 16);
            } else if (s.indexOf(58) >= 0) {
                s = s.replaceAll(":", "");
                bigArray[count] = new BigInteger(s, 16);
            } else {
                bigArray[count] = new BigInteger(s);
            }
            ++count;
        }
        return bigArray;
    }

    public static long toTimeStamp(String dateTime, SimpleDateFormat format, int timeZoneOffset) throws ParseException {
        Date formatDate = format.parse(dateTime);
        long miliSecondForDate = formatDate.getTime() - (long)timeZoneOffset;
        return miliSecondForDate / 1000L;
    }

    public static long toTimeStamp(String dateTime, String pattern, int timeZoneOffset) throws ParseException {
        SimpleDateFormat format = new SimpleDateFormat(pattern);
        return Util.toTimeStamp(dateTime, format, timeZoneOffset);
    }

    public static String fromTimeStamp(long timeStamp, SimpleDateFormat format) {
        Date formatDate = new Date(timeStamp);
        return format.format(formatDate);
    }

    public static String fromTimeStamp(long timeStamp, String pattern) {
        SimpleDateFormat format = new SimpleDateFormat(pattern);
        return Util.fromTimeStamp(timeStamp, format);
    }

    public static long toLong(Object obj) {
        return obj != null ? (Long)obj : 0L;
    }

    public static int toInt(Object obj) {
        return (int)Util.toLong(obj);
    }

    public static short toShort(Object obj) {
        return (short)Util.toLong(obj);
    }

    public static byte toByte(Object obj) {
        return (byte)Util.toLong(obj);
    }

    public static boolean toBoolean(Object obj) {
        return Util.toLong(obj) != 0L;
    }
}

