/*
 * Decompiled with CFR 0.152.
 */
package com.aerospike.client.async;

import com.aerospike.client.AerospikeException;
import com.aerospike.client.Log;
import com.aerospike.client.async.EventLoopBase;
import com.aerospike.client.async.EventState;
import com.aerospike.client.async.HashedWheelTimer;
import com.aerospike.client.async.TimerTask;
import com.aerospike.client.cluster.Cluster;
import com.aerospike.client.cluster.Node;
import com.aerospike.client.util.Util;
import java.util.concurrent.TimeUnit;

public abstract class AsyncConnector
implements Runnable,
TimerTask {
    final EventLoopBase eventLoop;
    final EventState eventState;
    final Cluster cluster;
    final Node node;
    final Listener listener;
    int state;
    HashedWheelTimer.HashedWheelTimeout timeoutTask;

    AsyncConnector(EventLoopBase eventLoop, Cluster cluster, Node node, Listener listener) {
        this.eventLoop = eventLoop;
        this.eventState = cluster.eventState[eventLoop.index];
        this.cluster = cluster;
        this.node = node;
        this.listener = listener;
    }

    public final void execute() {
        if (this.eventState.errors < 5) {
            this.run();
        } else {
            this.eventLoop.execute(this);
        }
    }

    @Override
    public void run() {
        long deadline = System.nanoTime() + TimeUnit.MILLISECONDS.toNanos(this.cluster.connectionTimeout);
        if (this.timeoutTask == null || !this.eventLoop.timer.isRunning()) {
            this.timeoutTask = this.eventLoop.timer.addTimeout(this, deadline);
        } else {
            this.eventLoop.timer.restoreTimeout(this.timeoutTask, deadline);
        }
        this.state = 3;
        try {
            this.createConnection();
            this.eventState.errors = 0;
        }
        catch (AerospikeException ae) {
            ++this.eventState.errors;
            this.fail(ae);
        }
        catch (Exception e) {
            ++this.eventState.errors;
            this.fail(new AerospikeException(e));
        }
    }

    @Override
    public final void timeout() {
        this.timeoutTask = null;
        this.fail(new AerospikeException.Timeout(this.node, this.cluster.connectionTimeout));
    }

    final void success() {
        if (this.state == 11) {
            return;
        }
        this.addConnection();
        this.close();
        try {
            this.listener.onSuccess(this);
        }
        catch (Exception e) {
            Log.error("onSuccess() error: " + Util.getErrorMessage(e));
        }
    }

    final void fail(AerospikeException ae) {
        if (this.state == 11) {
            return;
        }
        this.closeConnection();
        this.close();
        try {
            this.listener.onFailure(ae);
        }
        catch (Exception e) {
            Log.error("onFailure() error: " + Util.getErrorMessage(e));
        }
    }

    private final void close() {
        if (this.timeoutTask != null) {
            this.timeoutTask.cancel();
        }
        this.state = 11;
    }

    abstract void createConnection();

    abstract void addConnection();

    abstract void closeConnection();

    static interface Listener {
        public void onSuccess(AsyncConnector var1);

        public void onFailure(AerospikeException var1);
    }
}

