/*
 * Decompiled with CFR 0.152.
 */
package com.aerospike.client.async;

import com.aerospike.client.AerospikeException;
import com.aerospike.client.async.AsyncCommand;
import com.aerospike.client.async.EventState;
import com.aerospike.client.async.HashedWheelTimer;
import com.aerospike.client.async.INioCommand;
import com.aerospike.client.async.NioCommand;
import com.aerospike.client.async.NioConnection;
import com.aerospike.client.async.NioEventLoop;
import com.aerospike.client.async.TimerTask;
import com.aerospike.client.cluster.Node;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.channels.SelectionKey;
import java.util.concurrent.TimeUnit;

public final class NioRecover
implements INioCommand,
TimerTask {
    private final NioEventLoop eventLoop;
    private final Node node;
    private final EventState eventState;
    private final NioConnection conn;
    private final HashedWheelTimer.HashedWheelTimeout timeoutTask;
    private final ByteBuffer byteBuffer;
    private int offset;
    private int length;
    private int state;
    private final boolean isSingle;
    private final boolean checkReturnCode;
    private boolean isLastGroup;

    public NioRecover(NioCommand cmd) {
        AsyncCommand a = cmd.command;
        this.eventLoop = cmd.eventLoop;
        this.node = cmd.node;
        this.eventState = cmd.eventState;
        this.conn = cmd.conn;
        this.byteBuffer = cmd.byteBuffer;
        switch (cmd.state) {
            case 6: {
                this.offset = this.byteBuffer.position();
                this.length = this.byteBuffer.limit();
                this.state = 9;
                this.isSingle = true;
                this.checkReturnCode = true;
                break;
            }
            case 7: {
                this.offset = this.byteBuffer.position();
                this.length = this.byteBuffer.limit();
                this.state = 10;
                this.isSingle = true;
                this.checkReturnCode = true;
                break;
            }
            case 10: {
                if (a.isSingle) {
                    this.offset = this.byteBuffer.position();
                    this.length = this.byteBuffer.limit();
                } else {
                    byte info3;
                    this.offset = a.dataOffset;
                    this.length = a.receiveSize;
                    if (a.dataOffset >= 4 && ((info3 = a.dataBuffer[3]) & 1) != 0) {
                        this.isLastGroup = true;
                    }
                }
                this.state = cmd.state;
                this.isSingle = a.isSingle;
                this.checkReturnCode = false;
                break;
            }
            default: {
                this.offset = this.byteBuffer.position();
                this.length = this.byteBuffer.limit();
                this.state = cmd.state;
                this.isSingle = a.isSingle;
                this.checkReturnCode = false;
            }
        }
        ++this.eventState.pending;
        ++this.eventLoop.pending;
        this.conn.attach(this);
        this.timeoutTask = this.eventLoop.timer.addTimeout(this, System.nanoTime() + TimeUnit.MILLISECONDS.toNanos(a.policy.timeoutDelay));
    }

    @Override
    public final void timeout() {
        if (this.state == 11) {
            return;
        }
        this.abort(false);
    }

    @Override
    public final void processEvent(SelectionKey key) {
        try {
            int ops = key.readyOps();
            if ((ops & 1) != 0) {
                switch (this.state) {
                    case 9: {
                        if (this.isSingle) {
                            this.drainSingleHeader();
                            break;
                        }
                        if (!this.drainMultiHeader()) break;
                        this.drainMultiBody();
                        break;
                    }
                    case 10: {
                        if (this.isSingle) {
                            this.drainSingleBody();
                            break;
                        }
                        this.drainMultiBody();
                    }
                }
            }
        }
        catch (Exception e) {
            this.abort(true);
        }
    }

    private final void drainSingleHeader() throws IOException {
        if (!this.conn.read(this.byteBuffer)) {
            return;
        }
        this.byteBuffer.position(0);
        this.length = (int)(this.byteBuffer.getLong() & 0xFFFFFFFFFFFFL);
        this.byteBuffer.clear();
        if (this.length < this.byteBuffer.capacity()) {
            this.byteBuffer.limit(this.length);
        }
        this.offset = 0;
        this.state = 10;
        this.drainSingleBody();
    }

    private final void drainSingleBody() throws IOException {
        do {
            int resultCode;
            if (!this.conn.read(this.byteBuffer)) {
                return;
            }
            if (!this.checkReturnCode || (resultCode = this.byteBuffer.get(1) & 0xFF) == 0) continue;
            this.abort(false);
            return;
        } while (this.resetBuffer());
        this.recover();
    }

    private final boolean drainMultiHeader() throws IOException {
        boolean compressed;
        long proto;
        while (true) {
            if (!this.conn.read(this.byteBuffer)) {
                return false;
            }
            this.byteBuffer.position(0);
            proto = this.byteBuffer.getLong();
            this.length = (int)(proto & 0xFFFFFFFFFFFFL);
            if (this.length > 0) break;
            this.byteBuffer.clear();
            this.byteBuffer.limit(8);
        }
        boolean bl = compressed = (proto >> 48 & 0xFFL) == 4L;
        if (compressed) {
            throw new AerospikeException("Recovering connections with compressed multi-record data is not supported");
        }
        this.byteBuffer.clear();
        if (this.length < this.byteBuffer.capacity()) {
            this.byteBuffer.limit(this.length);
        }
        this.offset = 0;
        this.state = 10;
        return true;
    }

    private final void drainMultiBody() throws IOException {
        while (true) {
            byte info3;
            if (!this.conn.read(this.byteBuffer)) {
                return;
            }
            if (this.offset < 4 && ((info3 = this.byteBuffer.get(3)) & 1) != 0) {
                this.isLastGroup = true;
            }
            if (this.resetBuffer()) continue;
            if (this.isLastGroup) {
                this.recover();
                return;
            }
            this.byteBuffer.clear();
            this.byteBuffer.limit(8);
            this.state = 9;
            if (!this.drainMultiHeader()) break;
        }
    }

    private final boolean resetBuffer() {
        this.offset += this.byteBuffer.limit();
        if (this.offset < this.length) {
            this.byteBuffer.clear();
            int remaining = this.length - this.offset;
            if (remaining < this.byteBuffer.capacity()) {
                this.byteBuffer.limit(remaining);
            }
            return true;
        }
        return false;
    }

    private final void recover() {
        this.conn.unregister();
        this.conn.updateLastUsed();
        this.node.putAsyncConnection(this.conn, this.eventLoop.index);
        this.close(true);
    }

    private final void abort(boolean cancelTimeout) {
        this.node.closeAsyncConnection(this.conn, this.eventLoop.index);
        this.close(cancelTimeout);
    }

    private final void close(boolean cancelTimeout) {
        if (cancelTimeout) {
            this.timeoutTask.cancel();
        }
        if (this.byteBuffer != null) {
            this.eventLoop.putByteBuffer(this.byteBuffer);
        }
        this.state = 11;
        --this.eventState.pending;
        --this.eventLoop.pending;
        this.eventLoop.tryDelayQueue();
    }
}

