/*
 * Decompiled with CFR 0.152.
 */
package com.aerospike.client.async;

import java.util.concurrent.locks.Condition;
import java.util.concurrent.locks.ReentrantLock;

public final class Throttle {
    private final ReentrantLock lock = new ReentrantLock(false);
    private final Condition avail = this.lock.newCondition();
    private int available;

    public Throttle(int capacity) {
        this.available = capacity;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean waitForSlot(int count) {
        ReentrantLock lock = this.lock;
        lock.lockInterruptibly();
        try {
            while (this.available < count) {
                this.avail.await();
            }
            this.available -= count;
            boolean bl = true;
            lock.unlock();
            return bl;
        }
        catch (Throwable throwable) {
            try {
                lock.unlock();
                throw throwable;
            }
            catch (InterruptedException ie) {
                return false;
            }
        }
    }

    public void addSlot(int count) {
        this.lock.lock();
        try {
            this.available += count;
            this.avail.signal();
        }
        finally {
            this.lock.unlock();
        }
    }

    public int getAvailable() {
        return this.available;
    }
}

