/*
 * Decompiled with CFR 0.152.
 */
package com.agilejava.docbkx.maven;

import com.agilejava.docbkx.maven.AbstractMojoBase;
import java.io.File;
import java.io.IOException;
import java.net.URL;
import javax.xml.transform.Transformer;
import org.apache.maven.plugin.MojoExecutionException;
import org.codehaus.plexus.archiver.zip.ZipArchiver;
import org.codehaus.plexus.util.FileUtils;

public abstract class AbstractEpub3Mojo
extends AbstractMojoBase {
    public void adjustTransformer(Transformer transformer, String sourceFilename, File targetFile) {
        super.adjustTransformer(transformer, sourceFilename, targetFile);
        String rootFilename = targetFile.getName();
        rootFilename = rootFilename.substring(0, rootFilename.lastIndexOf(46));
        transformer.setParameter("root.filename", rootFilename);
        transformer.setParameter("base.dir", targetFile.getParent() + File.separator);
        transformer.setParameter("epub.package.dir", targetFile.getParent() + File.separator);
        transformer.setParameter("epub.metainf.dir", File.separator + "META-INF" + File.separator);
        transformer.setParameter("chunk.base.dir", targetFile.getParent() + File.separator);
        transformer.setParameter("epub.package.filename", "content.opf");
    }

    public void postProcessResult(File result) throws MojoExecutionException {
        super.postProcessResult(result);
        File targetDirectory = result.getParentFile();
        try {
            URL containerURL = ((Object)((Object)this)).getClass().getResource("/epub/container.xml");
            FileUtils.copyURLToFile((URL)containerURL, (File)new File(targetDirectory, "META-INF" + File.separator + "container.xml"));
        }
        catch (IOException e) {
            throw new MojoExecutionException("Unable to copy hardcoded container.xml file", (Exception)e);
        }
        try {
            ZipArchiver zipArchiver = new ZipArchiver();
            zipArchiver.addDirectory(targetDirectory);
            zipArchiver.setCompress(true);
            zipArchiver.setDestFile(new File(targetDirectory.getParentFile(), result.getName()));
            zipArchiver.createArchive();
            this.getLog().debug((CharSequence)("epub file created at: " + zipArchiver.getDestFile().getAbsolutePath()));
        }
        catch (Exception e) {
            throw new MojoExecutionException("Unable to zip epub file", e);
        }
    }
}

