/*
 * Decompiled with CFR 0.152.
 */
package com.agilejava.docbkx.maven;

import com.agilejava.docbkx.maven.AbstractMojoBase;
import java.io.File;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.net.URL;
import java.util.zip.CRC32;
import javax.xml.transform.Transformer;
import org.apache.maven.plugin.MojoExecutionException;
import org.codehaus.plexus.archiver.ArchiverException;
import org.codehaus.plexus.archiver.zip.ZipArchiver;
import org.codehaus.plexus.archiver.zip.ZipEntry;
import org.codehaus.plexus.archiver.zip.ZipOutputStream;
import org.codehaus.plexus.util.FileUtils;

public abstract class AbstractEpub3Mojo
extends AbstractMojoBase {
    public void adjustTransformer(Transformer transformer, String sourceFilename, File targetFile) {
        super.adjustTransformer(transformer, sourceFilename, targetFile);
        String rootFilename = targetFile.getName();
        rootFilename = rootFilename.substring(0, rootFilename.lastIndexOf(46));
        transformer.setParameter("root.filename", rootFilename);
        transformer.setParameter("base.dir", targetFile.getParent() + File.separator);
        transformer.setParameter("epub.package.dir", targetFile.getParent() + File.separator);
        transformer.setParameter("epub.metainf.dir", File.separator + "META-INF" + File.separator);
        transformer.setParameter("chunk.base.dir", targetFile.getParent() + File.separator);
        transformer.setParameter("epub.package.filename", "content.opf");
    }

    private static byte[] makeMimetype() throws UnsupportedEncodingException {
        return "application/epub+zip".getBytes("UTF-8");
    }

    public void postProcessResult(File result) throws MojoExecutionException {
        byte[] mimetypeData;
        super.postProcessResult(result);
        File targetDirectory = result.getParentFile();
        try {
            URL containerURL = ((Object)((Object)this)).getClass().getResource("/epub/container.epub3.xml");
            FileUtils.copyURLToFile((URL)containerURL, (File)new File(targetDirectory, "META-INF" + File.separator + "container.xml"));
        }
        catch (IOException e) {
            throw new MojoExecutionException("Unable to copy hardcoded container.xml file", (Exception)e);
        }
        try {
            mimetypeData = AbstractEpub3Mojo.makeMimetype();
        }
        catch (UnsupportedEncodingException e) {
            throw new MojoExecutionException("Unable to create mimetype data", (Exception)e);
        }
        try {
            File mimetype = new File(targetDirectory, "mimetype");
            mimetype.delete();
            ZipArchiver zipArchiver = new ZipArchiver(){

                protected void initZipOutputStream(ZipOutputStream zOut) throws IOException, ArchiverException {
                    CRC32 crc = new CRC32();
                    crc.update(mimetypeData);
                    ZipEntry ze = new ZipEntry("mimetype");
                    ze.setMethod(0);
                    ze.setSize((long)mimetypeData.length);
                    ze.setCrc(crc.getValue());
                    zOut.putNextEntry(ze);
                    zOut.write(mimetypeData);
                }
            };
            zipArchiver.addDirectory(targetDirectory);
            zipArchiver.setCompress(true);
            zipArchiver.setDestFile(new File(targetDirectory.getParentFile(), result.getName()));
            zipArchiver.createArchive();
            this.getLog().debug((CharSequence)("epub file created at: " + zipArchiver.getDestFile().getAbsolutePath()));
        }
        catch (Exception e) {
            throw new MojoExecutionException("Unable to zip epub file", e);
        }
    }
}

