/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.antx.config.descriptor.validator;

import com.alibaba.antx.config.descriptor.ConfigValidator;
import com.alibaba.antx.util.StringUtil;
import java.io.File;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FileExistValidator
extends ConfigValidator {
    private static final Logger log = LoggerFactory.getLogger(FileExistValidator.class);
    private String filename;
    private File file;

    public Logger getLogger() {
        return log;
    }

    public void setFile(String filename) {
        this.filename = filename;
    }

    public boolean validate(String value) {
        if (value == null) {
            return true;
        }
        if (StringUtil.isEmpty(value = value.trim())) {
            return true;
        }
        if (this.getLogger().isDebugEnabled()) {
            this.getLogger().debug("Validating file or directory: " + value);
        }
        this.file = this.filename == null ? new File(value) : new File(value, this.filename);
        return this.file.isAbsolute() && this.file.exists();
    }

    protected String getDefaultMessage() {
        return "\u6587\u4ef6\u6216\u76ee\u5f55\u4e0d\u5b58\u5728\uff0c\u6216\u4e0d\u662f\u7edd\u5bf9\u8def\u5f84\uff1a" + this.file;
    }
}

