/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.antx.config.entry;

import com.alibaba.antx.config.ConfigResource;
import com.alibaba.antx.config.ConfigSettings;
import com.alibaba.antx.config.descriptor.ConfigDescriptor;
import com.alibaba.antx.config.entry.ConfigEntryFactory;
import com.alibaba.antx.config.generator.ConfigGenerator;
import com.alibaba.antx.util.PatternSet;
import com.alibaba.antx.util.SelectorUtil;
import com.alibaba.antx.util.scanner.DefaultScannerHandler;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;

public abstract class ConfigEntry {
    private ConfigSettings settings;
    private ConfigResource resource;
    private File outputFile;
    private PatternSet descriptorPatterns;
    private PatternSet packagePatterns;
    protected ConfigEntry[] subEntries;
    private final ConfigGenerator generator;

    public ConfigEntry(ConfigResource resource, File outputFile, ConfigSettings settings) {
        this.resource = resource;
        this.outputFile = outputFile;
        this.settings = settings;
        this.generator = new ConfigGenerator(settings);
    }

    public String getName() {
        return this.getConfigEntryResource().getName();
    }

    public boolean isEmpty() {
        return this.getSubEntries().length == 0 && this.getGenerator().getConfigDescriptors().length == 0;
    }

    public ConfigResource getConfigEntryResource() {
        return this.resource;
    }

    public File getOutputFile() {
        return this.outputFile;
    }

    public ConfigSettings getConfigSettings() {
        return this.settings;
    }

    public PatternSet getDescriptorPatterns() {
        return this.descriptorPatterns;
    }

    public void setDescriptorPatterns(PatternSet descriptorPatterns) {
        this.descriptorPatterns = descriptorPatterns;
    }

    public PatternSet getPackagePatterns() {
        return this.packagePatterns;
    }

    public void setPackagePatterns(PatternSet packagePatterns) {
        this.packagePatterns = packagePatterns;
    }

    public ConfigGenerator getGenerator() {
        return this.generator;
    }

    public ConfigEntry[] getSubEntries() {
        return this.subEntries;
    }

    public void scan() {
        this.scan(null);
    }

    protected abstract void scan(InputStream var1);

    protected void populateDescriptorContext(Map context, String string) {
    }

    public boolean generate() {
        if (this.getOutputFile() != null) {
            this.settings.getOut().printf("Output file: %s%n%n", this.getOutputFile().getAbsolutePath());
        }
        return this.generate(null, null);
    }

    protected abstract boolean generate(InputStream var1, OutputStream var2);

    public class Handler
    extends DefaultScannerHandler {
        private List subEntries = new ArrayList();

        public ConfigEntry[] getSubEntries() {
            return this.subEntries.toArray(new ConfigEntry[this.subEntries.size()]);
        }

        public void startScanning() {
            StringBuffer buffer = new StringBuffer();
            buffer.append("Scanning ").append(this.getScanner().getBaseURL()).append("\n");
            buffer.append("  descriptors: ").append(ConfigEntry.this.getDescriptorPatterns()).append("\n");
            buffer.append("     packages: ").append(ConfigEntry.this.getPackagePatterns()).append("\n");
            ConfigEntry.this.settings.debug(buffer.toString());
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        public void file() {
            ConfigEntry subEntry;
            block6: {
                String name = this.getScanner().getPath();
                if (this.isDescriptorFile(name)) {
                    ConfigEntry.this.settings.debug("Loading descriptor " + this.getScanner().getURL() + "\n");
                    this.loadDescriptor();
                    return;
                }
                if (!this.isPackageFile(name)) return;
                ConfigResource resource = new ConfigResource(this.getScanner().getURL(), name);
                ConfigEntryFactory factory = ConfigEntry.this.getConfigSettings().getConfigEntryFactory();
                subEntry = this.createSubEntry(name, resource, factory);
                InputStream istream = null;
                try {
                    istream = this.getScanner().getInputStream();
                    subEntry.scan(istream);
                    Object var7_6 = null;
                    if (istream == null) break block6;
                }
                catch (Throwable throwable) {
                    Object var7_7 = null;
                    if (istream == null) throw throwable;
                    try {
                        istream.close();
                        throw throwable;
                    }
                    catch (IOException e) {
                        // empty catch block
                    }
                    throw throwable;
                }
                try {}
                catch (IOException e) {}
                istream.close();
            }
            if (subEntry.isEmpty()) return;
            this.subEntries.add(subEntry);
        }

        public void directory() {
            String name = this.getScanner().getPath();
            if (this.isPackageFile(name)) {
                ConfigResource resource = new ConfigResource(this.getScanner().getURL(), name);
                ConfigEntryFactory factory = ConfigEntry.this.getConfigSettings().getConfigEntryFactory();
                ConfigEntry subEntry = this.createSubEntry(name, resource, factory);
                subEntry.scan();
                if (!subEntry.isEmpty()) {
                    this.subEntries.add(subEntry);
                }
            }
        }

        private ConfigEntry createSubEntry(String name, ConfigResource resource, ConfigEntryFactory factory) {
            ConfigEntry subEntry = ConfigEntry.this.outputFile != null && (!ConfigEntry.this.outputFile.exists() || ConfigEntry.this.outputFile.isDirectory()) ? factory.create(resource, new File(ConfigEntry.this.outputFile, name), null) : factory.create(resource, null, null);
            return subEntry;
        }

        public boolean followUp() {
            String name = this.getScanner().getPath();
            boolean followUp = false;
            followUp |= SelectorUtil.matchPathPrefix(name, ConfigEntry.this.getDescriptorPatterns().getIncludes(), ConfigEntry.this.getDescriptorPatterns().getExcludes());
            followUp |= SelectorUtil.matchPathPrefix(name, ConfigEntry.this.getPackagePatterns().getIncludes(), ConfigEntry.this.getPackagePatterns().getExcludes());
            if (this.isPackageFile(name)) {
                return false;
            }
            if (!followUp) {
                ConfigEntry.this.getConfigSettings().debug("Skipping directory " + name);
            }
            return followUp;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        private void loadDescriptor() {
            ConfigDescriptor descriptor;
            block5: {
                URL descriptorURL = this.getScanner().getURL();
                ConfigResource descriptorResource = new ConfigResource(descriptorURL, this.getScanner().getPath());
                InputStream istream = null;
                try {
                    istream = this.getScanner().getInputStream();
                    descriptor = ConfigEntry.this.getGenerator().addConfigDescriptor(descriptorResource, istream);
                    Object var6_5 = null;
                    if (istream == null) break block5;
                }
                catch (Throwable throwable) {
                    Object var6_6 = null;
                    if (istream == null) throw throwable;
                    try {
                        istream.close();
                        throw throwable;
                    }
                    catch (IOException e) {
                        // empty catch block
                    }
                    throw throwable;
                }
                try {}
                catch (IOException e) {}
                istream.close();
            }
            ConfigEntry.this.populateDescriptorContext(descriptor.getContext(), descriptor.getName());
        }

        private boolean isDescriptorFile(String name) {
            return SelectorUtil.matchPath(name, ConfigEntry.this.getDescriptorPatterns().getIncludes(), ConfigEntry.this.getDescriptorPatterns().getExcludes());
        }

        private boolean isPackageFile(String name) {
            return SelectorUtil.matchPath(name, ConfigEntry.this.getPackagePatterns().getIncludes(), ConfigEntry.this.getPackagePatterns().getExcludes());
        }
    }
}

