/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.antx.config.entry;

import com.alibaba.antx.config.ConfigException;
import com.alibaba.antx.config.ConfigResource;
import com.alibaba.antx.config.ConfigSettings;
import com.alibaba.antx.config.entry.ConfigEntry;
import com.alibaba.antx.config.entry.ConfigEntryFactory;
import com.alibaba.antx.config.entry.DirectoryConfigEntry;
import com.alibaba.antx.config.entry.ZipConfigEntry;
import com.alibaba.antx.util.NumberUtil;
import com.alibaba.antx.util.PatternSet;
import com.alibaba.antx.util.StringUtil;
import com.alibaba.toolkit.util.regex.PathNameCompiler;
import java.io.File;
import java.util.Map;
import java.util.regex.Matcher;
import org.apache.oro.text.regex.MalformedPatternException;
import org.apache.oro.text.regex.Pattern;
import org.apache.oro.text.regex.Perl5Matcher;

public class ConfigEntryFactoryImpl
implements ConfigEntryFactory {
    private ConfigSettings settings;
    private static final java.util.regex.Pattern extPattern = java.util.regex.Pattern.compile("\\.(\\w+)$");

    public ConfigEntryFactoryImpl(ConfigSettings settings) {
        this.settings = settings;
    }

    public ConfigEntry create(ConfigResource resource, File outputFile, String type) {
        File file = resource.getFile();
        String name = resource.getName();
        if (type != null) {
            type = type.trim().toLowerCase();
        } else {
            Matcher m = extPattern.matcher(name);
            if (m.find()) {
                type = m.group(1).toLowerCase();
            }
        }
        if (StringUtil.isBlank(type)) {
            type = null;
        }
        if (name.endsWith("/")) {
            name = name.substring(0, name.length() - 1);
        }
        if (file != null && !file.exists()) {
            throw new IllegalArgumentException("File does not exist: " + file);
        }
        if ("war".equals(type) || file != null && file.isDirectory() && new File(file, "WEB-INF").isDirectory()) {
            return this.createWarEntry(resource, outputFile);
        }
        if ("jar".equals(type) || "ear".equals(type) || "rar".equals(type)) {
            return this.createGenericJarEntry(resource, outputFile);
        }
        if (file != null && file.isDirectory()) {
            return this.createGenericDirectoryEntry(resource, outputFile);
        }
        return this.createGenericJarEntry(resource, outputFile);
    }

    protected void populateCommonContext(Map context) {
        context.put("stringUtil", new StringUtil());
        context.put("numberUtil", new NumberUtil());
    }

    protected void populateWarContext(Map context, String name) {
        Pattern componentNamePattern;
        Perl5Matcher matcher = new Perl5Matcher();
        String componentName = "";
        try {
            componentNamePattern = new PathNameCompiler().compile("META-INF/**/autoconf/auto-config.xml");
        }
        catch (MalformedPatternException e) {
            throw new ConfigException(e);
        }
        if (matcher.matches(name.replace('\\', '/'), componentNamePattern)) {
            componentName = matcher.getMatch().group(1);
        }
        context.put("component", componentName);
    }

    private ConfigEntry createWarEntry(ConfigResource resource, File outputFile) {
        File file = resource.getFile();
        ConfigEntry entry = file != null && file.isDirectory() ? new DirectoryConfigEntry(resource, outputFile, this.settings){

            protected void populateDescriptorContext(Map context, String name) {
                ConfigEntryFactoryImpl.this.populateCommonContext(context);
                ConfigEntryFactoryImpl.this.populateWarContext(context, name);
            }
        } : new ZipConfigEntry(resource, outputFile, this.settings){

            protected void populateDescriptorContext(Map context, String name) {
                ConfigEntryFactoryImpl.this.populateCommonContext(context);
                ConfigEntryFactoryImpl.this.populateWarContext(context, name);
            }
        };
        entry.setDescriptorPatterns(new PatternSet("META-INF/**/auto-config.xml"));
        entry.setPackagePatterns(new PatternSet("WEB-INF/lib/*.jar"));
        return entry;
    }

    private ConfigEntry createGenericJarEntry(ConfigResource resource, File outputFile) {
        File file = resource.getFile();
        ConfigEntry entry = file != null && file.isDirectory() ? new DirectoryConfigEntry(resource, outputFile, this.settings){

            protected void populateDescriptorContext(Map context, String name) {
                ConfigEntryFactoryImpl.this.populateCommonContext(context);
            }
        } : new ZipConfigEntry(resource, outputFile, this.settings){

            protected void populateDescriptorContext(Map context, String name) {
                ConfigEntryFactoryImpl.this.populateCommonContext(context);
            }
        };
        entry.setDescriptorPatterns(new PatternSet("META-INF/**/auto-config.xml"));
        entry.setPackagePatterns(new PatternSet("**/*.jar, **/*.war, **/*.rar, **/*.ear"));
        return entry;
    }

    private ConfigEntry createGenericDirectoryEntry(ConfigResource resource, File outputFile) {
        DirectoryConfigEntry entry = new DirectoryConfigEntry(resource, outputFile, this.settings){

            protected void populateDescriptorContext(Map context, String name) {
                ConfigEntryFactoryImpl.this.populateCommonContext(context);
            }
        };
        entry.setDescriptorPatterns(new PatternSet(this.settings.getDescriptorPatterns(), new PatternSet("conf/**/auto-config.xml, META-INF/**/auto-config.xml")).addDefaultExcludes());
        entry.setPackagePatterns(new PatternSet(this.settings.getPackagePatterns(), new PatternSet(null, "**")).addDefaultExcludes());
        return entry;
    }
}

