/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.antx.config.generator;

import com.alibaba.antx.config.ConfigException;
import com.alibaba.antx.config.descriptor.ConfigDescriptor;
import com.alibaba.antx.config.descriptor.ConfigGenerate;
import com.alibaba.antx.config.generator.ConfigGenerator;
import com.alibaba.antx.config.generator.ConfigGeneratorCallback;
import com.alibaba.antx.config.generator.LazyGenerateItem;
import com.alibaba.antx.config.generator.PropertiesLoader;
import com.alibaba.antx.config.generator.PropertiesReferenceInsertionHandler;
import com.alibaba.antx.config.generator.VelocityTemplateEngine;
import com.alibaba.antx.config.props.PropertiesSet;
import com.alibaba.antx.util.StreamUtil;
import com.alibaba.antx.util.StringUtil;
import com.alibaba.antx.util.i18n.LocaleInfo;
import java.io.BufferedInputStream;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.io.Writer;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.velocity.app.event.EventCartridge;
import org.apache.velocity.context.AbstractContext;
import org.apache.velocity.context.Context;

public class ConfigGeneratorSession {
    protected final ConfigGenerator generator;
    protected final Map props;
    private final Map<String, Object[]> descriptorLogs;
    private final Set<String> processedDestfiles;
    private final Map<String, LazyGenerateItem> lazyGenerateItems;
    private ConfigGenerate currentGenerate;
    private InputStream currentInputStream;
    private OutputStream currentOutputStream;
    private static final Pattern encodingPattern = Pattern.compile("encoding\\s*=\\s*[\\\"|']([^\\\"|']+)[\\\"|']");

    protected ConfigGeneratorSession(ConfigGenerator generator, PropertiesSet propSet) {
        this.generator = generator;
        this.props = propSet.getMergedProperties();
        this.descriptorLogs = new HashMap<String, Object[]>();
        this.processedDestfiles = new HashSet<String>();
        this.lazyGenerateItems = new HashMap<String, LazyGenerateItem>();
        ConfigDescriptor[] descriptors = generator.getConfigDescriptors();
        Date now = new Date();
        for (ConfigDescriptor descriptor : descriptors) {
            String descriptorName = descriptor.getName();
            StringWriter logBuffer = new StringWriter();
            PrintWriter log = new PrintWriter((Writer)logBuffer, true);
            this.descriptorLogs.put(descriptorName, new Object[]{logBuffer, log, descriptor});
            log.println("Last Configured at: " + now);
            log.println();
            log.println("Base URL: " + descriptor.getBaseURL());
            log.println("Descriptor: " + descriptorName);
            log.println();
        }
    }

    public void setInputStream(InputStream istream) {
        this.currentInputStream = istream;
    }

    public void setOutputStream(OutputStream ostream) {
        this.currentOutputStream = ostream;
    }

    public Context getVelocityContext() {
        if (this.currentGenerate == null) {
            throw new IllegalStateException("Have not call nextEntry method yet");
        }
        final HashMap descriptorProps = new HashMap(this.currentGenerate.getConfigDescriptor().getContext());
        EventCartridge eventCartridge = new EventCartridge();
        eventCartridge.addEventHandler(new PropertiesReferenceInsertionHandler(this.currentGenerate.getConfigDescriptor(), this.props));
        AbstractContext context = new AbstractContext(){

            public Object internalRemove(Object key) {
                return descriptorProps.remove(key);
            }

            public Object internalPut(String key, Object value) {
                return descriptorProps.put(key, value);
            }

            public Object[] internalGetKeys() {
                LinkedHashSet keys = new LinkedHashSet(ConfigGeneratorSession.this.props.keySet());
                keys.addAll(descriptorProps.keySet());
                return keys.toArray(new Object[keys.size()]);
            }

            public Object internalGet(String key) {
                if (descriptorProps.containsKey(key)) {
                    return descriptorProps.get(key);
                }
                return PropertiesLoader.evaluate(key, ConfigGeneratorSession.this.props);
            }

            public boolean internalContainsKey(Object key) {
                return descriptorProps.containsKey(key) || ConfigGeneratorSession.this.props.containsKey(key);
            }
        };
        eventCartridge.attachToContext(context);
        context.put("D", "$");
        return context;
    }

    public boolean generate(ConfigGeneratorCallback callback) {
        boolean allSuccess = true;
        for (String template : this.generator.generateTemplateFiles.keySet()) {
            allSuccess &= this.generate(template, callback);
        }
        this.generateLog(callback);
        return allSuccess;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean generate(String template, ConfigGeneratorCallback callback) {
        List<ConfigGenerate> generates = this.generator.generateTemplateFilesIncludingMetaInfos.get(template);
        if (generates == null || generates.isEmpty()) {
            throw new ConfigException("No defined template " + template);
        }
        boolean allSuccess = true;
        for (ConfigGenerate generate : generates) {
            Object var10_8;
            Object var8_7;
            try {
                this.currentGenerate = generate;
                template = callback.nextEntry(template, this.currentGenerate);
                if (this.currentInputStream == null || this.currentOutputStream == null) {
                    throw new IllegalStateException("InputStream/OutputStream has not been set");
                }
                allSuccess &= this.generate(template, this.currentGenerate, this.currentInputStream, this.currentOutputStream);
                var8_7 = null;
            }
            catch (Throwable throwable) {
                var8_7 = null;
                try {
                    callback.closeEntry();
                    var10_8 = null;
                    this.currentGenerate = null;
                    this.currentInputStream = null;
                    this.currentOutputStream = null;
                }
                catch (Throwable throwable2) {
                    var10_8 = null;
                    this.currentGenerate = null;
                    this.currentInputStream = null;
                    this.currentOutputStream = null;
                    throw throwable2;
                }
                throw throwable;
            }
            try {
                callback.closeEntry();
                var10_8 = null;
                this.currentGenerate = null;
                this.currentInputStream = null;
                this.currentOutputStream = null;
            }
            catch (Throwable throwable) {
                var10_8 = null;
                this.currentGenerate = null;
                this.currentInputStream = null;
                this.currentOutputStream = null;
                throw throwable;
            }
        }
        return allSuccess;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private boolean generate(String template, ConfigGenerate generate, InputStream istream, OutputStream ostream) {
        boolean bl;
        this.processedDestfiles.add(generate.getDestfile());
        String charset = generate.getCharset();
        String outputCharset = generate.getOutputCharset();
        PrintWriter descriptorLog = (PrintWriter)this.descriptorLogs.get(generate.getConfigDescriptor().getName())[1];
        if (StringUtil.isBlank(charset)) {
            istream = new BufferedInputStream(istream);
            charset = this.guessCharsetEncoding((BufferedInputStream)istream);
        }
        if (StringUtil.isBlank(charset)) {
            charset = "ISO-8859-1";
        }
        if (StringUtil.isBlank(outputCharset)) {
            outputCharset = charset;
        }
        BufferedReader reader = null;
        Writer writer = null;
        try {
            try {
                reader = new BufferedReader(new InputStreamReader(istream, charset)){

                    public void close() throws IOException {
                    }
                };
                writer = new BufferedWriter(new OutputStreamWriter(ostream, outputCharset)){

                    public void close() throws IOException {
                    }
                };
                descriptorLog.println("Generating " + template + " [" + charset + "] => " + generate.getDestfile() + " [" + outputCharset + "]");
                this.generator.logger.info("<" + generate.getConfigDescriptor().getBaseURL() + ">\n    Generating " + template + " [" + charset + "] => " + generate.getDestfile() + " [" + outputCharset + "]\n");
                bl = VelocityTemplateEngine.getInstance().render(this.getVelocityContext(), reader, writer, template, generate.getConfigDescriptor().getName(), generate.getConfigDescriptor().getBaseURL());
                Object var12_12 = null;
                if (writer == null) return bl;
            }
            catch (Exception e) {
                if (!(e instanceof RuntimeException)) throw new ConfigException(e);
                throw (RuntimeException)e;
            }
        }
        catch (Throwable throwable) {
            Object var12_13 = null;
            if (writer == null) throw throwable;
            try {
                writer.flush();
                throw throwable;
            }
            catch (IOException e2) {
                throw throwable;
            }
        }
        try {}
        catch (IOException e2) {
            // empty catch block
            return bl;
        }
        writer.flush();
        return bl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String guessCharsetEncoding(BufferedInputStream istream) {
        String str;
        try {
            byte[] buf = new byte[1024];
            int count = 0;
            try {
                istream.mark(buf.length);
                count = istream.read(buf);
                Object var6_6 = null;
            }
            catch (Throwable throwable) {
                Object var6_7 = null;
                istream.reset();
                throw throwable;
            }
            istream.reset();
            str = new String(buf, 0, count, "ISO_8859_1");
        }
        catch (Exception e) {
            str = "";
        }
        Matcher m = encodingPattern.matcher(str);
        String charset = null;
        if (m.find()) {
            charset = m.group(1).trim();
        }
        return charset;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void generateLog(ConfigGeneratorCallback callback) {
        Iterator<Object[]> i$ = this.descriptorLogs.values().iterator();
        while (i$.hasNext()) {
            Object var15_12;
            Object[] logPair = i$.next();
            try {
                block10: {
                    IOException e3;
                    Object var12_10;
                    StringWriter logBuffer = (StringWriter)logPair[0];
                    PrintWriter log = (PrintWriter)logPair[1];
                    ConfigDescriptor descriptor = (ConfigDescriptor)logPair[2];
                    String logfile = this.generator.getDescriptorLogFile(descriptor);
                    callback.logEntry(descriptor, logfile);
                    String logContent = logBuffer.toString();
                    Writer writer = null;
                    try {
                        try {
                            writer = new BufferedWriter(new OutputStreamWriter(this.currentOutputStream, LocaleInfo.getDefault().getCharset())){

                                public void close() throws IOException {
                                }
                            };
                            this.generator.logger.info("<" + descriptor.getBaseURL() + ">\n    Generating log file: " + logfile + "\n");
                            writer.write(logContent);
                        }
                        catch (IOException e2) {
                            throw new ConfigException(e2);
                        }
                        var12_10 = null;
                        if (writer == null) break block10;
                    }
                    catch (Throwable throwable) {
                        var12_10 = null;
                        if (writer == null) throw throwable;
                        try {
                            writer.flush();
                            throw throwable;
                        }
                        catch (IOException e3) {
                            // empty catch block
                        }
                        throw throwable;
                    }
                    try {}
                    catch (IOException e3) {}
                    writer.flush();
                }
                var15_12 = null;
                callback.closeEntry();
                this.currentGenerate = null;
                this.currentInputStream = null;
                this.currentOutputStream = null;
            }
            catch (Throwable throwable) {
                var15_12 = null;
                callback.closeEntry();
                this.currentGenerate = null;
                this.currentInputStream = null;
                this.currentOutputStream = null;
                throw throwable;
            }
        }
    }

    public void addLazyGenerateItem(String name, byte[] bytes) {
        this.lazyGenerateItems.put(name, new LazyGenerateItem(name, this.generator.generateTemplateFilesIncludingMetaInfos.get(name), bytes));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    public boolean generateLazyItems(ConfigGeneratorCallback callback) {
        boolean allSuccess = true;
        for (LazyGenerateItem item : this.lazyGenerateItems.values()) {
            String name = item.getTemplateName();
            for (ConfigGenerate generate : item.getGenerates()) {
                Object v1;
                Object var17_13;
                Throwable throwable62;
                Object var15_11;
                Object var13_10;
                String destname = generate.getDestfile();
                if (this.processedDestfiles.contains(destname)) continue;
                this.currentGenerate = generate;
                callback.nextEntry(generate.getConfigDescriptor(), item.getTemplateContentStream(), generate.getTemplateBase() + name);
                if (this.currentInputStream == null || this.currentOutputStream == null) {
                    throw new IllegalStateException("InputStream/OutputStream has not been set");
                }
                StreamUtil.io(this.currentInputStream, this.currentOutputStream, true, false);
                Object var11_9 = null;
                try {
                    callback.closeEntry();
                    var13_10 = null;
                    this.currentGenerate = null;
                    this.currentInputStream = null;
                    this.currentOutputStream = null;
                }
                catch (Throwable throwable2) {
                    var13_10 = null;
                    this.currentGenerate = null;
                    this.currentInputStream = null;
                    this.currentOutputStream = null;
                    throw throwable2;
                }
                {
                    catch (IOException e) {
                        throw new RuntimeException(e);
                    }
                }
                catch (Throwable throwable3) {
                    var11_9 = null;
                    try {
                        callback.closeEntry();
                        var13_10 = null;
                        this.currentGenerate = null;
                        this.currentInputStream = null;
                        this.currentOutputStream = null;
                    }
                    catch (Throwable throwable4) {
                        var13_10 = null;
                        this.currentGenerate = null;
                        this.currentInputStream = null;
                        this.currentOutputStream = null;
                        throw throwable4;
                    }
                    throw throwable3;
                }
                try {
                    this.currentGenerate = generate;
                    callback.nextEntry(generate.getConfigDescriptor(), item.getTemplateContentStream(), generate.getDestfile());
                    if (this.currentInputStream == null || this.currentOutputStream == null) {
                        throw new IllegalStateException("InputStream/OutputStream has not been set");
                    }
                    allSuccess &= this.generate(name, generate, this.currentInputStream, this.currentOutputStream);
                    var15_11 = null;
                }
                catch (Throwable throwable5) {
                    Object v0;
                    var15_11 = null;
                    try {
                        callback.closeEntry();
                        v0 = null;
                    }
                    catch (Throwable throwable62) {
                        v0 = null;
                    }
                    var17_13 = v0;
                    this.currentGenerate = null;
                    this.currentInputStream = null;
                    this.currentOutputStream = null;
                    throw throwable5;
                }
                try {
                    callback.closeEntry();
                    v1 = null;
                }
                catch (Throwable throwable62) {
                    v1 = null;
                }
                var17_13 = v1;
                this.currentGenerate = null;
                this.currentInputStream = null;
                this.currentOutputStream = null;
                {
                }
            }
        }
        return allSuccess;
    }

    public void checkNonprocessedTemplates() {
        for (String destfile : this.generator.generateDestFiles.keySet()) {
            if (this.processedDestfiles.contains(destfile)) continue;
            ConfigGenerate generate = this.generator.generateDestFiles.get(destfile);
            String template = generate.getTemplate();
            throw new ConfigException("Could not find template file: " + template + " for descriptor: " + generate.getConfigDescriptor().getURL());
        }
    }

    public void close() {
    }
}

