/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.antx.config.generator;

import com.alibaba.antx.config.ConfigException;
import com.alibaba.antx.config.descriptor.ConfigDescriptor;
import com.alibaba.antx.config.descriptor.ConfigGenerate;
import com.alibaba.antx.config.generator.ConfigGenerator;
import com.alibaba.antx.config.generator.ConfigGeneratorCallback;
import com.alibaba.antx.util.StreamUtil;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;

public class DirectoryCallback
implements ConfigGeneratorCallback {
    private final ConfigGenerator generator;
    private File destfileBase;
    private InputStream istream;
    private OutputStream ostream;

    public DirectoryCallback(ConfigGenerator generator) {
        this.generator = generator;
    }

    public DirectoryCallback(ConfigGenerator generator, File destfileBase) {
        this.generator = generator;
        this.destfileBase = destfileBase;
    }

    public String nextEntry(String template, ConfigGenerate generate) {
        ConfigDescriptor descriptor = generate.getConfigDescriptor();
        String base = generate.getTemplateBase();
        template = generate.getTemplate();
        String dest = generate.getDestfile();
        File templateBase = descriptor.getBaseFile();
        File destfileBase = this.destfileBase;
        if (destfileBase == null) {
            destfileBase = templateBase;
        }
        File destFile = new File(destfileBase, dest);
        File templateFile = new File(templateBase, base + template);
        File templateFileInPlace = new File(templateBase, template);
        if (!templateFile.exists()) {
            if (!templateFileInPlace.exists()) {
                throw new ConfigException("Could not find template file: " + templateFileInPlace.getAbsolutePath() + " for descriptor: " + descriptor.getURL());
            }
            if (templateFileInPlace.getAbsolutePath().equals(destFile.getAbsolutePath())) {
                templateFile.getParentFile().mkdirs();
                try {
                    StreamUtil.io(new FileInputStream(templateFileInPlace), new FileOutputStream(templateFile), true, true);
                }
                catch (Exception e) {
                    throw new RuntimeException(e);
                }
            } else {
                templateFile = templateFileInPlace;
            }
        } else {
            template = base + template;
        }
        File destBase = destFile.getParentFile();
        destBase.mkdirs();
        if (!destBase.isDirectory()) {
            throw new ConfigException("Could not create directory: " + destBase.getAbsolutePath());
        }
        try {
            this.istream = new BufferedInputStream(new FileInputStream(templateFile), 8192);
            this.ostream = new BufferedOutputStream(new FileOutputStream(destFile), 8192);
        }
        catch (FileNotFoundException e) {
            throw new ConfigException(e);
        }
        this.generator.getSession().setInputStream(this.istream);
        this.generator.getSession().setOutputStream(this.ostream);
        return template;
    }

    public void nextEntry(ConfigDescriptor descriptor, InputStream is, String dest) {
    }

    public void logEntry(ConfigDescriptor descriptor, String logfileName) {
        File templateBase = descriptor.getBaseFile();
        File destfileBase = this.destfileBase;
        if (destfileBase == null) {
            destfileBase = templateBase;
        }
        File logfile = new File(destfileBase, logfileName);
        File logbase = logfile.getParentFile();
        logbase.mkdirs();
        if (!logbase.isDirectory()) {
            throw new ConfigException("Could not create directory: " + logbase.getAbsolutePath());
        }
        try {
            this.ostream = new BufferedOutputStream(new FileOutputStream(logfile), 8192);
        }
        catch (FileNotFoundException e) {
            throw new ConfigException(e);
        }
        this.generator.getSession().setOutputStream(this.ostream);
    }

    public void closeEntry() {
        if (this.istream != null) {
            try {
                this.istream.close();
            }
            catch (IOException e) {
                // empty catch block
            }
            this.istream = null;
        }
        if (this.ostream != null) {
            try {
                this.ostream.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
            this.ostream = null;
        }
    }
}

