/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.antx.config.generator;

import com.alibaba.antx.config.descriptor.ConfigDescriptor;
import com.alibaba.antx.config.descriptor.ConfigGroup;
import com.alibaba.antx.config.descriptor.ConfigProperty;
import com.alibaba.antx.config.generator.PropertiesLoader;
import com.alibaba.antx.util.StringUtil;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.velocity.app.event.ReferenceInsertionEventHandler;
import org.apache.velocity.context.Context;
import org.apache.velocity.util.ContextAware;

public class PropertiesReferenceInsertionHandler
implements ReferenceInsertionEventHandler,
ContextAware {
    private static final Pattern referencePattern = Pattern.compile("\\s*\\$\\s*\\!?\\s*(\\{\\s*(.*?)\\s*\\}|(.*?))\\s*");
    private Context context;
    private Map<String, Boolean> definedProperties;
    private Map<String, String> props;

    public PropertiesReferenceInsertionHandler(ConfigDescriptor configDescriptor, Map props) {
        this.props = props;
        this.definedProperties = new HashMap<String, Boolean>();
        for (ConfigGroup group : configDescriptor.getGroups()) {
            for (ConfigProperty prop : group.getProperties()) {
                this.definedProperties.put(prop.getName(), prop.isRequired());
                this.definedProperties.put(StringUtil.getValidIdentifier(prop.getName()), prop.isRequired());
            }
        }
    }

    public Object referenceInsert(String reference, Object value) {
        if (value != null) {
            return value;
        }
        String normalizedRef = PropertiesReferenceInsertionHandler.normalizeReference(reference);
        value = PropertiesLoader.evaluate(normalizedRef, this.props);
        if (value == null) {
            value = "";
        }
        Set unknownRefs = (Set)this.context.get("_unknwonRefs");
        if (!this.definedProperties.containsKey(normalizedRef) && unknownRefs != null) {
            unknownRefs.add(normalizedRef);
        }
        return value;
    }

    public void setContext(Context context) {
        this.context = context;
    }

    private static String normalizeReference(String reference) {
        if (reference == null) {
            return "";
        }
        Matcher matcher = referencePattern.matcher(reference);
        if (matcher.matches()) {
            String form1 = matcher.group(2);
            String form2 = matcher.group(3);
            if (form1 == null) {
                return form2;
            }
            return form1;
        }
        return reference;
    }
}

