/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.antx.config.generator.expr;

import com.alibaba.antx.config.generator.expr.Expression;
import com.alibaba.antx.config.generator.expr.ExpressionContext;
import com.alibaba.antx.util.StringUtil;

public class ReferenceExpression
implements Expression {
    private String ref;

    public ReferenceExpression(String ref) {
        this.ref = ref;
    }

    public String getExpressionText() {
        return "${" + this.ref + "}";
    }

    public Object evaluate(final ExpressionContext context) {
        if (StringUtil.isBlank(this.ref)) {
            return null;
        }
        Object value = context.get(this.ref);
        if (value == null) {
            return null;
        }
        if (value instanceof Expression) {
            return ((Expression)value).evaluate(new ExpressionContext(){

                public Object get(String key) {
                    if (ReferenceExpression.this.ref.equals(key) || StringUtil.getValidIdentifier(ReferenceExpression.this.ref).equals(StringUtil.getValidIdentifier(key))) {
                        return null;
                    }
                    return context.get(key);
                }

                public void put(String key, Object value) {
                    context.put(key, value);
                }
            });
        }
        return value;
    }

    public String toString() {
        return this.getExpressionText();
    }
}

