/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.antx.config.props;

import com.alibaba.antx.config.resource.Resource;
import com.alibaba.antx.config.resource.ResourceManager;
import com.alibaba.antx.config.resource.ResourceNotFoundException;
import com.alibaba.antx.util.i18n.LocaleInfo;
import java.io.File;
import java.net.URI;

public abstract class PropertiesResource {
    protected final ResourceManager manager;
    private boolean allowNonExistence;
    private boolean loaded;
    private Resource resource;
    private URI uri;
    private String charset;

    public PropertiesResource(ResourceManager manager) {
        this(manager, false);
    }

    public PropertiesResource(ResourceManager manager, boolean allowNonExistence) {
        this.manager = manager;
        this.allowNonExistence = allowNonExistence;
    }

    public URI getURI() {
        return this.uri;
    }

    protected void setURI(URI uri) {
        this.uri = uri;
    }

    protected void setURI(File file) {
        this.uri = file == null ? null : file.toURI();
    }

    public String getCharset() {
        if (this.charset == null) {
            return LocaleInfo.getDefault().getCharset();
        }
        return this.charset;
    }

    public void setCharset(String charset) {
        this.charset = charset;
    }

    public Resource getResource() {
        return this.resource;
    }

    protected void setResource(Resource res) {
        this.resource = res;
    }

    public boolean isAllowNonExistence() {
        return this.allowNonExistence;
    }

    public void setAllowNonExistence(boolean allowNonExistence) {
        this.allowNonExistence = allowNonExistence;
    }

    public final void reload() {
        this.loaded = false;
        this.load();
    }

    protected final void load() {
        block6: {
            if (!this.loaded) {
                this.loaded = true;
                try {
                    if (this.manager != null) {
                        if (this.resource == null && this.uri != null) {
                            this.resource = this.manager.getResource(this.uri);
                        }
                        this.manager.log("Loading " + this.uri);
                    }
                    this.onLoad();
                }
                catch (ResourceNotFoundException e) {
                    if (!this.allowNonExistence) {
                        throw e;
                    }
                    if (this.manager == null) break block6;
                    this.manager.log("Not exists: " + this.uri);
                    this.onError();
                }
            }
        }
    }

    protected void onLoad() {
    }

    protected void onError() {
    }

    public String toString() {
        String className = this.getClass().getName();
        String desc = this.uri == null ? "" : this.uri.toString();
        return className.substring(className.lastIndexOf(".") + 1) + "[" + desc + "]";
    }
}

