/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.antx.config.resource;

import com.alibaba.antx.config.ConfigException;
import com.alibaba.antx.config.resource.Session;
import com.alibaba.antx.util.FileUtil;
import com.alibaba.antx.util.StringUtil;
import java.io.File;
import java.io.UnsupportedEncodingException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URLDecoder;
import java.util.HashMap;
import java.util.Map;
import java.util.StringTokenizer;
import org.apache.oro.text.perl.Perl5Util;

public class ResourceURI {
    private static final Perl5Util util = new Perl5Util();
    private final URI uri;
    private final Map options;

    public static void main(String[] args) throws Exception {
        System.out.println(ResourceURI.guessURI("file://c:/aaa/bbb"));
    }

    public static URI guessURI(String file) {
        URI uri = null;
        if (!util.match("/^\\w:/", file)) {
            try {
                uri = new URI(file);
                if (!uri.isAbsolute()) {
                    uri = null;
                }
            }
            catch (URISyntaxException uRISyntaxException) {
                // empty catch block
            }
        }
        if (uri == null) {
            uri = new File(FileUtil.getPathBasedOn(new File("").getAbsolutePath(), file)).toURI();
        }
        return uri;
    }

    public ResourceURI(URI uri) {
        this(uri, (Session)null);
    }

    public ResourceURI(URI uri, Session session) {
        String query = uri.getQuery();
        HashMap<String, String> options = new HashMap<String, String>();
        StringBuffer newQuery = new StringBuffer();
        if (!StringUtil.isEmpty(query)) {
            StringTokenizer tokenizer = new StringTokenizer(query, "&");
            while (tokenizer.hasMoreElements()) {
                String value;
                String key;
                String token = StringUtil.trimWhitespace(tokenizer.nextToken());
                if (StringUtil.isEmpty(token)) continue;
                int index = token.indexOf("=");
                if (index <= 0) {
                    key = token;
                    value = "true";
                } else {
                    key = token.substring(0, index);
                    value = token.substring(index + 1);
                }
                try {
                    key = StringUtil.trimWhitespace(URLDecoder.decode(key, "UTF-8"));
                    value = StringUtil.trimWhitespace(URLDecoder.decode(value, "UTF-8"));
                }
                catch (UnsupportedEncodingException e) {
                    throw new ConfigException(e);
                }
                if (!StringUtil.isEmpty(key) && session != null && session.acceptOption(key)) {
                    options.put(key, value);
                    continue;
                }
                if (newQuery.length() > 0) {
                    newQuery.append("&");
                }
                newQuery.append(token);
            }
        }
        String newQueryStr = newQuery.length() > 0 ? newQuery.toString() : "";
        try {
            this.uri = new URI(this.replace(uri.toString(), query, newQueryStr));
        }
        catch (URISyntaxException e) {
            throw new ConfigException(e);
        }
        this.options = options;
    }

    private String replace(String text, String repl, String with) {
        if (text == null || repl == null || with == null || repl.length() == 0) {
            return text;
        }
        StringBuilder buf = new StringBuilder(text.length());
        int start = 0;
        int end = 0;
        end = text.indexOf(repl, start);
        if (end != -1) {
            buf.append(text.substring(start, end)).append(with);
            start = end + repl.length();
        }
        buf.append(text.substring(start));
        return buf.toString();
    }

    public ResourceURI(URI uri, Map options) {
        this.uri = uri;
        this.options = options;
    }

    public final URI getURI() {
        return this.uri;
    }

    public final String getPath() {
        return this.uri.getPath();
    }

    public final File getFile() {
        return new File(this.uri);
    }

    public final String getName() {
        String path = this.uri.getPath();
        if (path.endsWith("/")) {
            path = path.substring(0, path.length() - 1);
        }
        return path.substring(path.lastIndexOf("/") + 1);
    }

    public ResourceURI getSubURI(String subname) {
        return this.getSubURI(subname, false);
    }

    public ResourceURI getSubURI(String subname, boolean directory) {
        URI suburi;
        String path = this.uri.getPath();
        if (!path.endsWith("/") && !StringUtil.isEmpty(subname)) {
            path = path + "/";
        }
        String subpath = path + subname;
        if (directory) {
            subpath = subpath + "/";
        }
        try {
            suburi = new URI(this.uri.getScheme(), this.uri.getUserInfo(), this.uri.getHost(), this.uri.getPort(), subpath, this.uri.getQuery(), this.uri.getFragment()).normalize();
        }
        catch (URISyntaxException e) {
            throw new ConfigException(e);
        }
        return new ResourceURI(suburi, this.options);
    }

    public ResourceURI getSuperURI() {
        URI superuri;
        String path = this.uri.getPath();
        if (StringUtil.isEmpty(path) || path.equals("/")) {
            return null;
        }
        String superpath = path + "/../";
        try {
            superuri = new URI(this.uri.getScheme(), this.uri.getUserInfo(), this.uri.getHost(), this.uri.getPort(), superpath, this.uri.getQuery(), this.uri.getFragment()).normalize();
        }
        catch (URISyntaxException e) {
            throw new ConfigException(e);
        }
        return new ResourceURI(superuri, this.options);
    }

    public boolean guessDirectory() {
        return this.uri.getPath().endsWith("/");
    }

    public final String getOption(String name) {
        return (String)this.options.get(name);
    }

    public String toString() {
        return this.uri.toString();
    }
}

