/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.antx.config.resource.http;

import com.alibaba.antx.config.resource.AuthenticationHandler;
import com.alibaba.antx.config.resource.Resource;
import com.alibaba.antx.config.resource.ResourceDriver;
import com.alibaba.antx.config.resource.ResourceURI;
import com.alibaba.antx.config.resource.Session;
import com.alibaba.antx.config.resource.http.HttpResource;
import com.alibaba.antx.config.resource.util.ResourceContext;
import com.alibaba.antx.config.resource.util.ResourceKey;
import java.net.URI;
import java.util.Set;
import org.apache.commons.httpclient.Credentials;
import org.apache.commons.httpclient.HttpClient;
import org.apache.commons.httpclient.UsernamePasswordCredentials;
import org.apache.commons.httpclient.auth.AuthScheme;
import org.apache.commons.httpclient.auth.CredentialsNotAvailableException;
import org.apache.commons.httpclient.auth.CredentialsProvider;

public class HttpSession
extends Session {
    private final HttpClient client = new HttpClient();

    public HttpSession(ResourceDriver driver) {
        super(driver);
        this.client.getParams().setAuthenticationPreemptive(true);
        this.client.getParams().setParameter("http.authentication.credential-provider", new CredentialsProvider(){

            public Credentials getCredentials(AuthScheme scheme, String host, int port, boolean proxy) throws CredentialsNotAvailableException {
                URI uri = ResourceContext.get().getCurrentURI();
                String username = ResourceContext.get().getCurrentUsername();
                Set visitedURIs = ResourceContext.get().getVisitedURIs();
                ResourceKey key = new ResourceKey(new ResourceURI(uri));
                String message = "\n";
                message = message + "Authentication required.\n";
                message = message + "realm: " + scheme.getRealm() + "\n";
                message = message + "  uri: " + uri + "\n";
                AuthenticationHandler.UsernamePassword up = HttpSession.this.getResourceManager().getAuthenticationHandler().authenticate(message, uri, username, visitedURIs.contains(key));
                visitedURIs.add(key);
                return new UsernamePasswordCredentials(up.getUsername(), up.getPassword());
            }
        });
    }

    public HttpClient getClient() {
        return this.client;
    }

    public boolean acceptOption(String optionName) {
        return "charset".equals(optionName);
    }

    public Resource getResource(ResourceURI uri) {
        return new HttpResource(this, uri);
    }
}

