/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.antx.config.resource.util;

import com.alibaba.antx.config.resource.Resource;
import com.alibaba.antx.config.resource.util.IndexPageParser;
import com.alibaba.antx.config.resource.util.TextBasedPageParser;
import java.io.UnsupportedEncodingException;
import java.net.URLDecoder;
import java.util.ArrayList;
import java.util.List;
import org.dom4j.Document;
import org.dom4j.Node;

public class ApacheIndexPageParser
extends TextBasedPageParser {
    public ApacheIndexPageParser() {
    }

    public ApacheIndexPageParser(String overridingCharset) {
        super(overridingCharset);
    }

    public List parse(Resource resource) {
        Node title;
        Document doc = this.getHtmlDocument(resource);
        if (doc != null && (title = doc.selectSingleNode("//head/title")) != null && title.getText() != null && title.getText().startsWith("Index of")) {
            List nodes = doc.selectNodes("//pre/img[starts-with(@alt,'[') and ends-with(@alt,']')]/following::a/@href");
            ArrayList<IndexPageParser.Item> items = new ArrayList<IndexPageParser.Item>(nodes.size());
            for (Node node : nodes) {
                IndexPageParser.Item item;
                String name = node.getText();
                try {
                    name = URLDecoder.decode(name, this.getCharset(resource));
                }
                catch (UnsupportedEncodingException e) {
                    // empty catch block
                }
                if ((item = this.getItem(name)) == null) continue;
                items.add(item);
            }
            return items;
        }
        return null;
    }
}

