/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.antx.config.wizard.text;

import com.alibaba.antx.config.ConfigSettings;
import com.alibaba.antx.config.descriptor.ConfigDescriptor;
import com.alibaba.antx.config.entry.ConfigEntry;
import com.alibaba.antx.config.props.PropertiesSet;
import com.alibaba.antx.config.wizard.text.ConfigWizard;
import com.alibaba.antx.config.wizard.text.ConfigWizardException;
import java.util.ArrayList;
import java.util.List;

public class ConfigWizardLoader {
    private final ConfigSettings settings;
    private final List configEntries;
    private final ConfigDescriptor inlineDescriptor;

    public ConfigWizardLoader(ConfigSettings settings, List configEntries) {
        this.settings = settings;
        this.configEntries = configEntries;
        this.inlineDescriptor = null;
    }

    public ConfigWizardLoader(ConfigSettings settings, ConfigDescriptor inlineDescription) {
        this.settings = settings;
        this.configEntries = null;
        this.inlineDescriptor = inlineDescription;
    }

    public void loadAndStart() {
        ConfigDescriptor[] descriptors = this.getAllDescriptors();
        PropertiesSet props = this.settings.getPropertiesSet();
        ConfigWizard wizard = new ConfigWizard(descriptors, props, this.settings.getCharset());
        boolean valid = wizard.validate();
        String interactiveMode = this.settings.getInteractiveMode();
        boolean interactiveAuto = "auto".equals(interactiveMode);
        boolean interactiveOn = "on".equals(interactiveMode);
        if (interactiveOn || interactiveAuto && !valid) {
            if (!valid) {
                StringBuffer confirm = new StringBuffer();
                confirm.append("\u256d\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2508\u2508\u2508\u2508\n");
                confirm.append("\u2502\n");
                confirm.append("\u2502 \u60a8\u7684\u914d\u7f6e\u6587\u4ef6\u9700\u8981\u88ab\u66f4\u65b0\uff1a\n");
                confirm.append("\u2502\n");
                confirm.append("\u2502 ").append(props.getUserPropertiesFile().getURI()).append("\n");
                confirm.append("\u2502\n");
                confirm.append("\u2502 \u8fd9\u4e2a\u6587\u4ef6\u5305\u62ec\u4e86\u60a8\u4e2a\u4eba\u7684\u7279\u6b8a\u8bbe\u7f6e\uff0c\n");
                confirm.append("\u2502 \u5305\u62ec\u670d\u52a1\u5668\u7aef\u53e3\u3001\u60a8\u7684\u90ae\u4ef6\u5730\u5740\u7b49\u5185\u5bb9\u3002\n");
                confirm.append("\u2502\n");
                confirm.append("\u2514\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2508\u2508\u2508\u2508\u2508\u2508\u2508\u2508\u2508\u2508\u2508\n");
                confirm.append("\n").append(" \u5982\u679c\u4e0d\u66f4\u65b0\u6b64\u6587\u4ef6\uff0c\u53ef\u80fd\u4f1a\u5bfc\u81f4\u914d\u7f6e\u6587\u4ef6\u7684\u5185\u5bb9\u4e0d\u5b8c\u6574\u3002\n");
                confirm.append(" \u60a8\u9700\u8981\u73b0\u5728\u66f4\u65b0\u6b64\u6587\u4ef6\u5417?");
                wizard.setConfirmMessage(confirm.toString());
            }
            wizard.start();
            valid = wizard.validate();
        }
        if (!valid) {
            throw new ConfigWizardException("\u56e0\u4e3a\u914d\u7f6e\u6587\u4ef6\u201c" + props.getUserPropertiesFile().getURI() + "\u201d\u672a\u51c6\u5907\u597d\uff0c\u6240\u4ee5\u65e0\u6cd5\u7ee7\u7eed\u4e0b\u53bb\uff01");
        }
    }

    private ConfigDescriptor[] getAllDescriptors() {
        if (this.configEntries != null) {
            ArrayList descriptors = new ArrayList();
            for (ConfigEntry entry : this.configEntries) {
                this.addConfigEntryRecursive(entry, descriptors);
            }
            return descriptors.toArray(new ConfigDescriptor[descriptors.size()]);
        }
        if (this.inlineDescriptor != null) {
            return new ConfigDescriptor[]{this.inlineDescriptor};
        }
        return new ConfigDescriptor[0];
    }

    private void addConfigEntryRecursive(ConfigEntry entry, List descriptors) {
        ConfigEntry[] subEntries;
        ConfigDescriptor[] entryDescriptors;
        if (entry == null) {
            return;
        }
        for (ConfigDescriptor entryDescriptor : entryDescriptors = entry.getGenerator().getConfigDescriptors()) {
            descriptors.add(entryDescriptor);
        }
        for (ConfigEntry subEntrie : subEntries = entry.getSubEntries()) {
            this.addConfigEntryRecursive(subEntrie, descriptors);
        }
    }
}

