/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.toolkit.util.collection;

import com.alibaba.toolkit.util.collection.DefaultMapEntry;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.AbstractCollection;
import java.util.AbstractMap;
import java.util.AbstractSet;
import java.util.Arrays;
import java.util.Collection;
import java.util.ConcurrentModificationException;
import java.util.Iterator;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Set;

public class DefaultHashMap
extends AbstractMap
implements Map,
Cloneable,
Serializable {
    private static final int DEFAULT_INITIAL_CAPACITY = 16;
    private static final int MAXIMUM_CAPACITY = 0x40000000;
    private static final float DEFAULT_LOAD_FACTOR = 0.75f;
    protected transient Entry[] table;
    protected transient int size;
    protected int threshold;
    protected final float loadFactor;
    protected volatile transient int modCount;
    private transient Set keySet = null;
    private transient Set entrySet = null;
    private transient Collection values = null;
    private static final long serialVersionUID = 362498820763181265L;

    public DefaultHashMap() {
        this(16, 0.75f);
    }

    public DefaultHashMap(int initialCapacity) {
        this(initialCapacity, 0.75f);
    }

    public DefaultHashMap(int initialCapacity, float loadFactor) {
        int capacity;
        if (initialCapacity < 0) {
            throw new IllegalArgumentException("Illegal initial capacity: " + initialCapacity);
        }
        if (initialCapacity > 0x40000000) {
            initialCapacity = 0x40000000;
        }
        if (loadFactor <= 0.0f || Float.isNaN(loadFactor)) {
            throw new IllegalArgumentException("Illegal load factor: " + loadFactor);
        }
        for (capacity = 1; capacity < initialCapacity; capacity <<= 1) {
        }
        this.loadFactor = loadFactor;
        this.threshold = (int)((float)capacity * loadFactor);
        this.table = new Entry[capacity];
        this.onInit();
    }

    public DefaultHashMap(Map map) {
        this(Math.max((int)((float)map.size() / 0.75f) + 1, 16), 0.75f);
        this.putAllForCreate(map);
    }

    public int size() {
        return this.size;
    }

    public boolean isEmpty() {
        return this.size == 0;
    }

    public Object get(Object key) {
        Entry entry = this.getEntry(key);
        return entry == null ? null : entry.getValue();
    }

    public boolean containsKey(Object key) {
        Entry entry = this.getEntry(key);
        return entry != null;
    }

    public Object put(Object key, Object value) {
        Entry entry = this.getEntry(key);
        if (entry != null) {
            Object oldValue = entry.getValue();
            entry.setValue(value);
            entry.onAccess();
            return oldValue;
        }
        ++this.modCount;
        if (this.size >= this.threshold) {
            this.resize(this.table.length * 2);
        }
        this.addEntry(key, value);
        return null;
    }

    public void putAll(Map map) {
        int n = map.size();
        if (n == 0) {
            return;
        }
        if (n >= this.threshold) {
            int capacity;
            if ((n = (int)((float)n / this.loadFactor + 1.0f)) > 0x40000000) {
                n = 0x40000000;
            }
            for (capacity = this.table.length; capacity < n; capacity <<= 1) {
            }
            this.resize(capacity);
        }
        for (Map.Entry entry : map.entrySet()) {
            this.put(entry.getKey(), entry.getValue());
        }
    }

    public Object remove(Object key) {
        Entry entry = this.removeEntryForKey(key);
        return entry == null ? null : entry.getValue();
    }

    public void clear() {
        ++this.modCount;
        Arrays.fill(this.table, null);
        this.size = 0;
    }

    public boolean containsValue(Object value) {
        Entry[] tab;
        Entry[] arr$ = tab = this.table;
        int len$ = arr$.length;
        for (int i$ = 0; i$ < len$; ++i$) {
            Entry element;
            Entry entry = element = arr$[i$];
            while (entry != null) {
                if (DefaultHashMap.eq(value, entry.getValue())) {
                    return true;
                }
                entry = entry.next;
            }
        }
        return false;
    }

    public Set keySet() {
        Set ks = this.keySet;
        return ks != null ? ks : (this.keySet = new KeySet());
    }

    public Collection values() {
        Collection vs = this.values;
        return vs != null ? vs : (this.values = new Values());
    }

    public Set entrySet() {
        Set es = this.entrySet;
        return es != null ? es : (this.entrySet = new EntrySet());
    }

    private void readObject(ObjectInputStream is) throws IOException, ClassNotFoundException {
        is.defaultReadObject();
        int numBuckets = is.readInt();
        this.table = new Entry[numBuckets];
        this.onInit();
        int size = is.readInt();
        for (int i = 0; i < size; ++i) {
            Object key = is.readObject();
            Object value = is.readObject();
            this.putForCreate(key, value);
        }
    }

    private void writeObject(ObjectOutputStream os) throws IOException {
        os.defaultWriteObject();
        os.writeInt(this.table.length);
        os.writeInt(this.size);
        for (Map.Entry entry : this.entrySet()) {
            os.writeObject(entry.getKey());
            os.writeObject(entry.getValue());
        }
    }

    public Object clone() {
        DefaultHashMap result = null;
        try {
            result = (DefaultHashMap)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new InternalError();
        }
        result.table = new Entry[this.table.length];
        result.entrySet = null;
        result.modCount = 0;
        result.size = 0;
        result.onInit();
        result.putAllForCreate(this);
        return result;
    }

    protected void onInit() {
    }

    protected Entry getEntry(Object key) {
        int hash = DefaultHashMap.hash(key);
        int i = DefaultHashMap.indexFor(hash, this.table.length);
        Entry entry = this.table[i];
        while (entry != null) {
            if (entry.hash == hash && DefaultHashMap.eq(key, entry.getKey())) {
                return entry;
            }
            entry = entry.next;
        }
        return null;
    }

    protected void addEntry(Object key, Object value) {
        int hash = DefaultHashMap.hash(key);
        int i = DefaultHashMap.indexFor(hash, this.table.length);
        this.table[i] = new Entry(hash, key, value, this.table[i]);
        ++this.size;
    }

    private void putForCreate(Object key, Object value) {
        Entry entry = this.getEntry(key);
        if (entry != null) {
            entry.setValue(value);
        } else {
            this.addEntry(key, value);
        }
    }

    private void putAllForCreate(Map map) {
        for (Map.Entry entry : map.entrySet()) {
            this.putForCreate(entry.getKey(), entry.getValue());
        }
    }

    protected Entry removeEntryForKey(Object key) {
        Entry prev;
        int hash = DefaultHashMap.hash(key);
        int i = DefaultHashMap.indexFor(hash, this.table.length);
        Entry entry = prev = this.table[i];
        while (entry != null) {
            Entry next = entry.next;
            if (entry.hash == hash && DefaultHashMap.eq(key, entry.getKey())) {
                ++this.modCount;
                --this.size;
                if (prev == entry) {
                    this.table[i] = next;
                } else {
                    prev.next = next;
                }
                entry.onRemove();
                return entry;
            }
            prev = entry;
            entry = next;
        }
        return entry;
    }

    protected Entry removeEntry(Object o) {
        Entry prev;
        if (!(o instanceof Map.Entry)) {
            return null;
        }
        Map.Entry entry = (Map.Entry)o;
        Object key = entry.getKey();
        int hash = DefaultHashMap.hash(key);
        int i = DefaultHashMap.indexFor(hash, this.table.length);
        Entry e = prev = this.table[i];
        while (e != null) {
            Entry next = e.next;
            if (e.hash == hash && e.equals(entry)) {
                ++this.modCount;
                --this.size;
                if (prev == e) {
                    this.table[i] = next;
                } else {
                    prev.next = next;
                }
                e.onRemove();
                return e;
            }
            prev = e;
            e = next;
        }
        return e;
    }

    protected Iterator newKeyIterator() {
        return new KeyIterator();
    }

    protected Iterator newValueIterator() {
        return new ValueIterator();
    }

    protected Iterator newEntryIterator() {
        return new EntryIterator();
    }

    protected static int hash(Object obj) {
        int h = obj == null ? 0 : obj.hashCode();
        return h - (h << 7);
    }

    protected static boolean eq(Object x, Object y) {
        return x == null ? y == null : x == y || x.equals(y);
    }

    protected static int indexFor(int hash, int length) {
        return hash & length - 1;
    }

    protected void resize(int newCapacity) {
        Entry[] oldTable = this.table;
        int oldCapacity = oldTable.length;
        if (this.size < this.threshold || oldCapacity > newCapacity) {
            return;
        }
        Entry[] newTable = new Entry[newCapacity];
        this.transfer(newTable);
        this.table = newTable;
        this.threshold = (int)((float)newCapacity * this.loadFactor);
    }

    protected void transfer(Entry[] newTable) {
        Entry[] src = this.table;
        int newCapacity = newTable.length;
        for (int j = 0; j < src.length; ++j) {
            Entry next;
            Entry entry = src[j];
            if (entry == null) continue;
            src[j] = null;
            do {
                next = entry.next;
                int i = DefaultHashMap.indexFor(entry.hash, newCapacity);
                entry.next = newTable[i];
                newTable[i] = entry;
            } while ((entry = next) != null);
        }
    }

    protected int getCapacity() {
        return this.table.length;
    }

    protected float getLoadFactor() {
        return this.loadFactor;
    }

    protected int getThreshold() {
        return this.threshold;
    }

    private class EntrySet
    extends AbstractSet {
        private EntrySet() {
        }

        public Iterator iterator() {
            return DefaultHashMap.this.newEntryIterator();
        }

        public boolean contains(Object o) {
            if (!(o instanceof Map.Entry)) {
                return false;
            }
            Map.Entry entry = (Map.Entry)o;
            Entry candidate = DefaultHashMap.this.getEntry(entry.getKey());
            return DefaultHashMap.eq(candidate, entry);
        }

        public boolean remove(Object o) {
            return DefaultHashMap.this.removeEntry(o) != null;
        }

        public int size() {
            return DefaultHashMap.this.size;
        }

        public void clear() {
            DefaultHashMap.this.clear();
        }
    }

    private class Values
    extends AbstractCollection {
        private Values() {
        }

        public Iterator iterator() {
            return DefaultHashMap.this.newValueIterator();
        }

        public int size() {
            return DefaultHashMap.this.size;
        }

        public boolean contains(Object o) {
            return DefaultHashMap.this.containsValue(o);
        }

        public void clear() {
            DefaultHashMap.this.clear();
        }
    }

    private class KeySet
    extends AbstractSet {
        private KeySet() {
        }

        public Iterator iterator() {
            return DefaultHashMap.this.newKeyIterator();
        }

        public int size() {
            return DefaultHashMap.this.size;
        }

        public boolean contains(Object o) {
            return DefaultHashMap.this.containsKey(o);
        }

        public boolean remove(Object o) {
            return DefaultHashMap.this.removeEntryForKey(o) != null;
        }

        public void clear() {
            DefaultHashMap.this.clear();
        }
    }

    private class EntryIterator
    extends HashIterator {
        private EntryIterator() {
        }

        public Object next() {
            return this.nextEntry();
        }
    }

    private class ValueIterator
    extends HashIterator {
        private ValueIterator() {
        }

        public Object next() {
            return this.nextEntry().getValue();
        }
    }

    private class KeyIterator
    extends HashIterator {
        private KeyIterator() {
        }

        public Object next() {
            return this.nextEntry().getKey();
        }
    }

    private abstract class HashIterator
    implements Iterator {
        private Entry current;
        private Entry next;
        private int expectedModCount;
        private int index;

        protected HashIterator() {
            this.expectedModCount = DefaultHashMap.this.modCount;
            Entry[] t = DefaultHashMap.this.table;
            int i = t.length;
            Entry n = null;
            if (DefaultHashMap.this.size != 0) {
                while (i > 0 && (n = t[--i]) == null) {
                }
            }
            this.next = n;
            this.index = i;
        }

        public boolean hasNext() {
            return this.next != null;
        }

        public void remove() {
            if (this.current == null) {
                throw new IllegalStateException();
            }
            this.checkForComodification();
            Object k = this.current.getKey();
            this.current = null;
            DefaultHashMap.this.removeEntryForKey(k);
            this.expectedModCount = DefaultHashMap.this.modCount;
        }

        protected Entry nextEntry() {
            this.checkForComodification();
            Entry entry = this.next;
            if (entry == null) {
                throw new NoSuchElementException();
            }
            Entry n = entry.next;
            Entry[] t = DefaultHashMap.this.table;
            int i = this.index;
            while (n == null && i > 0) {
                n = t[--i];
            }
            this.index = i;
            this.next = n;
            this.current = entry;
            return this.current;
        }

        private void checkForComodification() {
            if (DefaultHashMap.this.modCount != this.expectedModCount) {
                throw new ConcurrentModificationException();
            }
        }
    }

    protected static class Entry
    extends DefaultMapEntry {
        protected final int hash;
        protected Entry next;

        protected Entry(int h, Object k, Object v, Entry n) {
            super(k, v);
            this.next = n;
            this.hash = h;
        }

        protected void onAccess() {
        }

        protected void onRemove() {
        }
    }
}

