/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.toolkit.util.regex;

import java.text.MessageFormat;
import org.apache.oro.text.regex.MalformedPatternException;
import org.apache.oro.text.regex.Pattern;
import org.apache.oro.text.regex.PatternCompiler;
import org.apache.oro.text.regex.Perl5Compiler;

public abstract class Perl5CompilerWrapper
implements PatternCompiler {
    public static final int DEFAULT_MASK = 0;
    public static final int CASE_INSENSITIVE_MASK = 4096;
    public static final int READ_ONLY_MASK = 8192;
    protected static final char ESCAPE_CHAR = '\\';
    private static final String PERL5_META_CHARS = "*?+[]()|^$.{}\\";
    private static final String ERROR_UNEXPECTED_CHAR = "Unexpected \"{0}\" near \"{1}\"";
    protected final Perl5Compiler compiler = new Perl5Compiler();

    public Pattern compile(String pattern) throws MalformedPatternException {
        return this.compile(pattern.toCharArray(), 0);
    }

    public Pattern compile(String pattern, int options) throws MalformedPatternException {
        return this.compile(pattern.toCharArray(), options);
    }

    public Pattern compile(char[] pattern) throws MalformedPatternException {
        return this.compile(pattern, 0);
    }

    public Pattern compile(char[] pattern, int options) throws MalformedPatternException {
        int perlOptions = 0;
        if ((options & 0x1000) != 0) {
            perlOptions |= 1;
        }
        if ((options & 0x2000) != 0) {
            perlOptions |= 0x8000;
        }
        return this.compiler.compile(this.toPerl5Regex(pattern, options), perlOptions);
    }

    protected abstract String toPerl5Regex(char[] var1, int var2) throws MalformedPatternException;

    protected boolean isPerl5MetaChar(char ch) {
        return PERL5_META_CHARS.indexOf(ch) != -1;
    }

    protected String getDefaultErrorMessage(char[] pattern, int index) {
        return MessageFormat.format(ERROR_UNEXPECTED_CHAR, new Character(pattern[index]), new String(pattern, 0, index));
    }
}

