/*
 * Decompiled with CFR 0.152.
 */
package org.w3c.tidy;

import org.w3c.dom.Attr;
import org.w3c.tidy.AttrCheckImpl;
import org.w3c.tidy.Attribute;
import org.w3c.tidy.AttributeTable;
import org.w3c.tidy.DOMAttrImpl;
import org.w3c.tidy.Lexer;
import org.w3c.tidy.Node;
import org.w3c.tidy.Report;
import org.w3c.tidy.TagTable;

public class AttVal
implements Cloneable {
    public AttVal next;
    public Attribute dict;
    public Node asp;
    public Node php;
    public int delim;
    public String attribute;
    public String value;
    protected Attr adapter = null;

    public AttVal() {
        this.next = null;
        this.dict = null;
        this.asp = null;
        this.php = null;
        this.delim = 0;
        this.attribute = null;
        this.value = null;
    }

    public AttVal(AttVal next, Attribute dict, int delim, String attribute, String value) {
        this.next = next;
        this.dict = dict;
        this.asp = null;
        this.php = null;
        this.delim = delim;
        this.attribute = attribute;
        this.value = value;
    }

    public AttVal(AttVal next, Attribute dict, Node asp, Node php, int delim, String attribute, String value) {
        this.next = next;
        this.dict = dict;
        this.asp = asp;
        this.php = php;
        this.delim = delim;
        this.attribute = attribute;
        this.value = value;
    }

    protected Object clone() {
        AttVal av = new AttVal();
        if (this.next != null) {
            av.next = (AttVal)this.next.clone();
        }
        if (this.attribute != null) {
            av.attribute = this.attribute;
        }
        if (this.value != null) {
            av.value = this.value;
        }
        av.delim = this.delim;
        if (this.asp != null) {
            av.asp = (Node)this.asp.clone();
        }
        if (this.php != null) {
            av.php = (Node)this.php.clone();
        }
        av.dict = AttributeTable.getDefaultAttributeTable().findAttribute(this);
        return av;
    }

    public boolean isBoolAttribute() {
        Attribute attribute = this.dict;
        return attribute != null && attribute.attrchk == AttrCheckImpl.getCheckBool();
    }

    public Attribute checkAttribute(Lexer lexer, Node node) {
        Attribute attribute;
        TagTable tt = lexer.configuration.tt;
        if (this.asp == null && this.php == null) {
            this.checkUniqueAttribute(lexer, node);
        }
        if ((attribute = this.dict) != null) {
            if (attribute == AttributeTable.attrTitle && (node.tag == tt.tagA || node.tag == tt.tagLink)) {
                lexer.versions = (short)(lexer.versions & 0x1F);
            } else if ((attribute.versions & 0x20) != 0) {
                if (!lexer.configuration.XmlTags && !lexer.configuration.XmlOut) {
                    Report.attrError(lexer, node, this.attribute, (short)9);
                }
            } else {
                lexer.versions = (short)(lexer.versions & attribute.versions);
            }
            if (attribute.attrchk != null) {
                attribute.attrchk.check(lexer, node, this);
            }
        } else if (!(lexer.configuration.XmlTags || node.tag == null || this.asp != null || node.tag != null && (node.tag.versions & 0x1C0) != 0)) {
            Report.attrError(lexer, node, this.attribute, (short)1);
        }
        return attribute;
    }

    public void checkUniqueAttribute(Lexer lexer, Node node) {
        int count = 0;
        AttVal attr = this.next;
        while (attr != null) {
            if (this.attribute != null && attr.attribute != null && attr.asp == null && attr.php == null && Lexer.wstrcasecmp(this.attribute, attr.attribute) == 0) {
                ++count;
            }
            attr = attr.next;
        }
        if (count > 0) {
            Report.attrError(lexer, node, this.attribute, (short)7);
        }
    }

    protected Attr getAdapter() {
        if (this.adapter == null) {
            this.adapter = new DOMAttrImpl(this);
        }
        return this.adapter;
    }
}

