/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.antx.expand;

import com.alibaba.antx.expand.ExpanderException;
import com.alibaba.antx.expand.ExpanderLogger;
import com.alibaba.antx.util.FileObject;
import com.alibaba.antx.util.FileUtil;
import com.alibaba.antx.util.ZipUtil;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Date;
import java.util.HashSet;
import java.util.Set;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import org.apache.commons.digester.Digester;
import org.xml.sax.SAXException;

public class Expander {
    private final ExpanderLogger log;
    private boolean expandWar = true;
    private boolean expandRar = true;
    private boolean expandEjbjar = false;
    private boolean overwrite = false;
    private boolean keepRedundantFiles = false;
    private File srcfile;
    private File destdir;
    private Set expandedFiles;

    public Expander(ExpanderLogger log) {
        this.log = log;
    }

    public boolean isExpandWar() {
        return this.expandWar;
    }

    public boolean isExpandRar() {
        return this.expandRar;
    }

    public boolean isExpandEjbjar() {
        return this.expandEjbjar;
    }

    public boolean isOverwrite() {
        return this.overwrite;
    }

    public boolean isKeepRedundantFiles() {
        return this.keepRedundantFiles;
    }

    public File getSourceFile() {
        return this.srcfile;
    }

    public File getDestDir() {
        return this.destdir;
    }

    public void setExpandEjbjar(boolean expandEjbjar) {
        this.expandEjbjar = expandEjbjar;
    }

    public void setExpandRar(boolean expandRar) {
        this.expandRar = expandRar;
    }

    public void setExpandWar(boolean expandWar) {
        this.expandWar = expandWar;
    }

    public void setDestdir(String destdir) {
        String basedir = new File("").getAbsolutePath();
        this.destdir = new File(FileUtil.getPathBasedOn(basedir, destdir));
    }

    public void setSrcfile(String srcfile) {
        String basedir = new File("").getAbsolutePath();
        this.srcfile = new File(FileUtil.getPathBasedOn(basedir, srcfile));
    }

    public void setOverwrite(boolean overwrite) {
        this.overwrite = overwrite;
    }

    public void setKeepRedundantFiles(boolean keepRedundantFiles) {
        this.keepRedundantFiles = keepRedundantFiles;
    }

    private void init() {
        if (this.srcfile == null) {
            throw new ExpanderException("missing source file to expand");
        }
        this.srcfile = this.srcfile.getAbsoluteFile();
        if (!this.srcfile.exists() || !this.srcfile.isFile()) {
            throw new ExpanderException(this.srcfile + " does not exist or is not a file");
        }
        if (this.destdir == null) {
            String dirname = this.srcfile.getName();
            int index = dirname.lastIndexOf(".");
            dirname = index < 0 ? dirname + ".expanded" : dirname.substring(0, index);
            this.destdir = new File(this.srcfile.getParentFile(), dirname);
        }
        this.destdir = this.destdir.getAbsoluteFile();
        if (this.destdir.exists() && !this.destdir.isDirectory()) {
            throw new ExpanderException(this.destdir + " is not a directory");
        }
        this.destdir.mkdirs();
        if (!this.destdir.exists()) {
            throw new ExpanderException("could not create directory: " + this.destdir);
        }
    }

    public void expand() {
        this.init();
        this.log.info("Expanding: " + this.srcfile + "\n       To: " + this.destdir.getAbsolutePath());
        this.expandedFiles = new HashSet();
        InputStream istream = null;
        try {
            istream = new BufferedInputStream(new FileInputStream(this.srcfile), 8192);
            this.getExpanderHandler(this.srcfile.toURI().toURL()).expand(istream, this.destdir);
            this.removeRedundantFiles(this.destdir);
            this.log.info("done.");
        }
        catch (IOException e) {
            throw new ExpanderException(e);
        }
        finally {
            if (istream != null) {
                try {
                    istream.close();
                }
                catch (IOException e) {}
            }
            this.expandedFiles = null;
        }
    }

    protected void removeRedundantFiles(File fileOrDir) throws IOException {
        File[] files;
        if (this.isKeepRedundantFiles()) {
            return;
        }
        if (!fileOrDir.exists()) {
            return;
        }
        if (!fileOrDir.isDirectory()) {
            if (!this.expandedFiles.contains(fileOrDir.getCanonicalPath())) {
                this.log.info("- " + this.getPathRelativeToDestdir(fileOrDir) + " - " + (fileOrDir.delete() ? "deleted" : "can't delete"));
            }
            return;
        }
        for (File file : files = fileOrDir.listFiles()) {
            this.removeRedundantFiles(file);
        }
        if (!this.expandedFiles.contains(fileOrDir.getCanonicalPath()) && fileOrDir.delete()) {
            this.log.info("- " + this.getPathRelativeToDestdir(fileOrDir) + " - success");
        }
    }

    private ExpanderHandler getExpanderHandler(URL url) {
        String name = url.getFile();
        if ((name = name.substring(name.lastIndexOf("/") + 1)).endsWith(".war")) {
            return new WarExpanderHandler();
        }
        return new EarExpanderHandler(url);
    }

    private String getPathRelativeToDestdir(File file) {
        return new FileObject(this.destdir).newFileObject(file).getRelativePath();
    }

    private class EarExpanderHandler
    extends ExpanderHandler {
        private URL earURL;
        private URL applicationXmlURL;
        private Set ejbJars;

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public EarExpanderHandler(URL earURL) {
            this.earURL = earURL;
            try {
                this.applicationXmlURL = ZipUtil.getJarURL(this.earURL, "META-INF/application.xml");
            }
            catch (MalformedURLException e) {
                IllegalArgumentException iae = new IllegalArgumentException();
                iae.initCause(e);
                throw iae;
            }
            this.ejbJars = new HashSet();
            if (Expander.this.expandEjbjar) {
                InputStream istream = null;
                try {
                    istream = this.applicationXmlURL.openStream();
                    Expander.this.log.info("  Loading: " + this.applicationXmlURL);
                    this.readApplicationXml(istream);
                }
                catch (Exception e) {
                    Expander.this.log.warn("   failed - EJB-jars will not be expanded");
                }
                finally {
                    if (istream != null) {
                        try {
                            istream.close();
                        }
                        catch (IOException e) {}
                    }
                }
            }
        }

        private void readApplicationXml(InputStream istream) throws IOException, SAXException {
            Digester digester = new Digester();
            digester.addCallMethod("application/module/ejb", "add", 1);
            digester.addCallParam("application/module/ejb", 0);
            digester.push(this.ejbJars);
            digester.parse(istream);
        }

        protected boolean needToExpand(String name) {
            return super.needToExpand(name) || this.ejbJars.contains(name);
        }
    }

    private class WarExpanderHandler
    extends ExpanderHandler {
        private WarExpanderHandler() {
        }
    }

    private abstract class ExpanderHandler {
        private ExpanderHandler() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected void expand(InputStream istream, File todir) throws IOException {
            ZipInputStream zipStream = null;
            try {
                zipStream = new ZipInputStream(istream);
                ZipEntry zipEntry = null;
                while ((zipEntry = zipStream.getNextEntry()) != null) {
                    this.extractFile(todir, zipStream, zipEntry, null);
                }
            }
            finally {
                if (zipStream != null) {
                    try {
                        zipStream.close();
                    }
                    catch (IOException e) {}
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected void extractFile(File todir, InputStream zipStream, ZipEntry zipEntry, String url) throws IOException {
            String entryName = zipEntry.getName();
            Date entryDate = new Date(zipEntry.getTime());
            boolean isDirectory = zipEntry.isDirectory();
            File targetFile = FileUtil.getFile(todir, entryName);
            boolean expandFile = false;
            if (!isDirectory && url == null) {
                expandFile = this.needToExpand(zipEntry.getName());
            }
            if (!expandFile && !Expander.this.overwrite && targetFile.exists() && targetFile.lastModified() >= entryDate.getTime()) {
                Expander.this.log.debug(". " + Expander.this.getPathRelativeToDestdir(targetFile) + " - up-to-date");
                Expander.this.expandedFiles.add(targetFile.getCanonicalPath());
                return;
            }
            if (isDirectory) {
                Expander.this.expandedFiles.add(targetFile.getCanonicalPath());
                targetFile.mkdirs();
            } else {
                File dir = targetFile.getParentFile();
                dir.mkdirs();
                if (expandFile) {
                    Expander.this.log.info("X " + Expander.this.getPathRelativeToDestdir(targetFile));
                    if (targetFile.exists() && !targetFile.isDirectory()) {
                        targetFile.delete();
                    }
                    targetFile.mkdirs();
                    if (!targetFile.exists() || !targetFile.isDirectory()) {
                        throw new ExpanderException("could not create directory: " + targetFile);
                    }
                    ZipInputStream zis = new ZipInputStream(zipStream);
                    ZipEntry subEntry = null;
                    while ((subEntry = zis.getNextEntry()) != null) {
                        this.extractFile(targetFile, zis, subEntry, entryName);
                    }
                } else {
                    Expander.this.log.debug("+ " + Expander.this.getPathRelativeToDestdir(targetFile));
                    if (targetFile.exists() && targetFile.isDirectory()) {
                        FileUtil.deleteDirectory(targetFile);
                    }
                    if (targetFile.exists() && !targetFile.isFile()) {
                        throw new ExpanderException("could not create file: " + targetFile + ", it's a directory");
                    }
                    byte[] buffer = new byte[8192];
                    int length = 0;
                    OutputStream ostream = null;
                    try {
                        Expander.this.expandedFiles.add(targetFile.getCanonicalPath());
                        ostream = new BufferedOutputStream(new FileOutputStream(targetFile), 8192);
                        while ((length = zipStream.read(buffer)) >= 0) {
                            ostream.write(buffer, 0, length);
                        }
                    }
                    finally {
                        if (ostream != null) {
                            try {
                                ostream.close();
                            }
                            catch (IOException e) {}
                        }
                    }
                }
            }
            targetFile.setLastModified(entryDate.getTime());
        }

        protected boolean needToExpand(String name) {
            if (Expander.this.expandWar && name.endsWith(".war")) {
                return true;
            }
            return Expander.this.expandRar && name.endsWith(".rar");
        }
    }
}

