/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.antx.util;

import java.math.BigDecimal;
import java.math.BigInteger;

public class NumberUtil {
    public static Float createFloat(String val) {
        return Float.valueOf(val);
    }

    public static Double createDouble(String val) {
        return Double.valueOf(val);
    }

    public static Integer createInteger(String val) {
        return Integer.decode(val);
    }

    public static Long createLong(String val) {
        return Long.valueOf(val);
    }

    public static BigInteger createBigInteger(String val) {
        BigInteger bi = new BigInteger(val);
        return bi;
    }

    public static BigDecimal createBigDecimal(String val) {
        BigDecimal bd = new BigDecimal(val);
        return bd;
    }

    public static Number createNumber(String val) throws NumberFormatException {
        String mant;
        String dec;
        if (val == null) {
            return null;
        }
        if (val.length() == 0) {
            throw new NumberFormatException("\"\" is not a valid number.");
        }
        if (val.startsWith("--")) {
            return null;
        }
        if (val.startsWith("0x") || val.startsWith("-0x")) {
            return NumberUtil.createInteger(val);
        }
        char lastChar = val.charAt(val.length() - 1);
        int decPos = val.indexOf(46);
        int expPos = val.indexOf(101) + val.indexOf(69) + 1;
        if (decPos > -1) {
            if (expPos > -1) {
                if (expPos < decPos) {
                    throw new NumberFormatException(val + " is not a valid number.");
                }
                dec = val.substring(decPos + 1, expPos);
            } else {
                dec = val.substring(decPos + 1);
            }
            mant = val.substring(0, decPos);
        } else {
            mant = expPos > -1 ? val.substring(0, expPos) : val;
            dec = null;
        }
        if (!Character.isDigit(lastChar)) {
            String exp = expPos > -1 && expPos < val.length() - 1 ? val.substring(expPos + 1, val.length() - 1) : null;
            String numeric = val.substring(0, val.length() - 1);
            boolean allZeros = NumberUtil.isAllZeros(mant) && NumberUtil.isAllZeros(exp);
            switch (lastChar) {
                case 'L': 
                case 'l': {
                    if (dec == null && exp == null && NumberUtil.isDigits(numeric.substring(1)) && (numeric.charAt(0) == '-' || Character.isDigit(numeric.charAt(0)))) {
                        try {
                            return NumberUtil.createLong(numeric);
                        }
                        catch (NumberFormatException nfe) {
                            return NumberUtil.createBigInteger(numeric);
                        }
                    }
                    throw new NumberFormatException(val + " is not a valid number.");
                }
                case 'F': 
                case 'f': {
                    try {
                        Float f = NumberUtil.createFloat(numeric);
                        if (!f.isInfinite() && (f.floatValue() != 0.0f || allZeros)) {
                            return f;
                        }
                    }
                    catch (NumberFormatException nfe) {
                        // empty catch block
                    }
                }
                case 'D': 
                case 'd': {
                    try {
                        Double d = NumberUtil.createDouble(numeric);
                        if (!d.isInfinite() && ((double)d.floatValue() != 0.0 || allZeros)) {
                            return d;
                        }
                    }
                    catch (NumberFormatException nfe) {
                        // empty catch block
                    }
                    try {
                        return NumberUtil.createBigDecimal(numeric);
                    }
                    catch (NumberFormatException e) {
                        // empty catch block
                    }
                }
            }
            throw new NumberFormatException(val + " is not a valid number.");
        }
        String exp = expPos > -1 && expPos < val.length() - 1 ? val.substring(expPos + 1, val.length()) : null;
        if (dec == null && exp == null) {
            try {
                return NumberUtil.createInteger(val);
            }
            catch (NumberFormatException nfe) {
                try {
                    return NumberUtil.createLong(val);
                }
                catch (NumberFormatException nfe2) {
                    return NumberUtil.createBigInteger(val);
                }
            }
        }
        boolean allZeros = NumberUtil.isAllZeros(mant) && NumberUtil.isAllZeros(exp);
        try {
            Float f = NumberUtil.createFloat(val);
            if (!f.isInfinite() && (f.floatValue() != 0.0f || allZeros)) {
                return f;
            }
        }
        catch (NumberFormatException nfe) {
            // empty catch block
        }
        try {
            Double d = NumberUtil.createDouble(val);
            if (!d.isInfinite() && (d != 0.0 || allZeros)) {
                return d;
            }
        }
        catch (NumberFormatException nfe) {
            // empty catch block
        }
        return NumberUtil.createBigDecimal(val);
    }

    public static boolean isDigits(String str) {
        if (str == null || str.length() == 0) {
            return false;
        }
        for (int i = 0; i < str.length(); ++i) {
            if (Character.isDigit(str.charAt(i))) continue;
            return false;
        }
        return true;
    }

    private static boolean isAllZeros(String s) {
        if (s == null) {
            return true;
        }
        for (int i = s.length() - 1; i >= 0; --i) {
            if (s.charAt(i) == '0') continue;
            return false;
        }
        return s.length() > 0;
    }
}

