/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.antx.util;

import com.alibaba.antx.util.StringUtil;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.Toolkit;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.IOException;
import java.io.PrintWriter;
import java.lang.reflect.Method;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPasswordField;

public class PasswordField {
    public String getPassword(PrintWriter out, String oneLinePrompt) throws IOException {
        return this.getPassword(out, oneLinePrompt, null);
    }

    public String getPassword(PrintWriter out, String oneLinePrompt, String message) throws IOException {
        String pwd;
        if (message == null) {
            message = "";
        }
        if ((pwd = this.java6_console_password(out, oneLinePrompt)) != null) {
            return pwd;
        }
        pwd = this.swing_password(out, oneLinePrompt, message);
        if (pwd != null) {
            return pwd;
        }
        return this.ugly_password(out, oneLinePrompt);
    }

    private String swing_password(PrintWriter out, String oneLinePrompt, String message) {
        String password = null;
        try {
            JPasswordField passwordField = new JPasswordField(20);
            String[] lines = StringUtil.split(message + "\n" + oneLinePrompt, "\r\n");
            Object[] messages = new Object[lines.length + 1];
            for (int i = 0; i < lines.length; ++i) {
                messages[i] = new JLabel(lines[i]);
            }
            messages[lines.length] = passwordField;
            final JOptionPane pane = new JOptionPane(messages, 3, 2);
            final JDialog dialog = new JDialog((Frame)null, "Password required", true);
            dialog.setContentPane(pane);
            dialog.pack();
            dialog.setDefaultCloseOperation(0);
            pane.addPropertyChangeListener(new PropertyChangeListener(){

                public void propertyChange(PropertyChangeEvent e) {
                    String prop = e.getPropertyName();
                    if (dialog.isVisible() && e.getSource() == pane && prop.equals("value")) {
                        dialog.setVisible(false);
                        dialog.dispose();
                    }
                }
            });
            Toolkit toolkit = Toolkit.getDefaultToolkit();
            Dimension screenSize = toolkit.getScreenSize();
            int x = (screenSize.width - dialog.getWidth()) / 2;
            int y = (screenSize.height - dialog.getHeight()) / 2;
            dialog.setLocation(x, y);
            dialog.setVisible(true);
            int value = (Integer)pane.getValue();
            password = value == 0 ? new String(passwordField.getPassword()) : "";
        }
        catch (Exception e) {
            return null;
        }
        catch (Error e) {
            return null;
        }
        return password;
    }

    private String java6_console_password(PrintWriter out, String oneLinePrompt) {
        char[] password;
        Method consoleMethod = null;
        Method readPasswordMethod = null;
        try {
            consoleMethod = System.class.getMethod("console", new Class[0]);
            readPasswordMethod = consoleMethod.getReturnType().getMethod("readPassword", new Class[0]);
        }
        catch (NoSuchMethodException e) {
            System.err.println();
            System.err.println("------------------------------------------------------------------------");
            System.err.println(" \u7f3a\u5c11\u5bc6\u7801\u5de5\u5177\uff1a\u63a8\u8350\u4f7f\u7528Java6\u6216\u66f4\u65b0\u7248\u672c\uff0c\u5b83\u63d0\u4f9b\u4e86\u5728\u63a7\u5236\u53f0\u8f93\u5165\u5bc6\u7801\u7684\u5de5\u5177\u3002");
            System.err.println("                       ^^^^^^^^^^^^^^^                                  ");
            System.err.println(" \u4f46\u73b0\u5728\uff0c\u6211\u4eec\u53ea\u80fd\u4f7f\u7528\u4e00\u4e2a\u4e0d\u5b8c\u7f8e\u7684\u65b9\u6cd5\u6765\u4ee3\u66ff\u3002");
            System.err.println("------------------------------------------------------------------------");
            System.err.println();
            System.err.flush();
        }
        if (consoleMethod == null || readPasswordMethod == null) {
            return null;
        }
        try {
            Object console = consoleMethod.invoke(null, new Object[0]);
            if (console == null) {
                return null;
            }
            out.print(oneLinePrompt);
            out.flush();
            password = (char[])readPasswordMethod.invoke(console, new Object[0]);
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        return password == null ? "" : new String(password);
    }

    private String ugly_password(PrintWriter out, String oneLinePrompt) throws IOException {
        StringBuffer password = new StringBuffer();
        MaskingThread maskingthread = new MaskingThread(out, oneLinePrompt);
        Thread thread = new Thread(maskingthread);
        thread.start();
        while (true) {
            char c = (char)System.in.read();
            maskingthread.stopMasking();
            if (c == '\r') {
                c = (char)System.in.read();
                if (c != '\n') continue;
                break;
            }
            if (c == '\n') break;
            password.append(c);
        }
        return password.toString();
    }

    public static void main(String[] args) throws IOException {
        PasswordField pf = new PasswordField();
        String pass = pf.getPassword(new PrintWriter(System.out, true), "Enter password: ");
        System.out.println("password is " + pass);
    }

    class MaskingThread
    extends Thread {
        private boolean stop;
        private final PrintWriter out;
        private final String oneLinePrompt;

        public MaskingThread(PrintWriter out, String oneLinePrompt) {
            super("password-masking");
            this.stop = false;
            this.out = out;
            this.oneLinePrompt = oneLinePrompt;
        }

        public void run() {
            while (!this.stop) {
                try {
                    MaskingThread.sleep(1L);
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
                if (!this.stop) {
                    this.out.print("\r" + this.oneLinePrompt + " \r" + this.oneLinePrompt);
                }
                this.out.flush();
            }
        }

        public void stopMasking() {
            this.stop = true;
        }
    }
}

