/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.antx.util;

import com.alibaba.antx.util.FileUtil;
import com.alibaba.antx.util.StringUtil;
import com.alibaba.toolkit.util.collection.ArrayHashSet;
import java.util.ArrayList;

public class PatternSet {
    private String[] includes;
    private String[] excludes;

    public PatternSet() {
        this(new String[0], new String[0]);
    }

    public PatternSet(String includes) {
        this(StringUtil.split(includes), new String[0]);
    }

    public PatternSet(String includes, String excludes) {
        this(StringUtil.split(includes), StringUtil.split(excludes));
    }

    public PatternSet(String[] includes, String[] excludes) {
        this.includes = PatternSet.normalizePatterns(includes);
        this.excludes = PatternSet.normalizePatterns(excludes);
    }

    public PatternSet(PatternSet patterns, PatternSet defaultPatterns) {
        if ((patterns == null || patterns.isEmpty()) && (patterns = defaultPatterns) == null) {
            patterns = new PatternSet();
        }
        this.includes = patterns.includes;
        this.excludes = patterns.excludes;
    }

    private static String[] normalizePatterns(String[] patterns) {
        if (patterns == null) {
            return new String[0];
        }
        ArrayList<String> patternList = new ArrayList<String>(patterns.length);
        for (String pattern2 : patterns) {
            int startIndex;
            String pattern = pattern2;
            if (pattern == null) continue;
            pattern = pattern.trim().replace('\\', '/');
            int endIndex = pattern.length();
            for (startIndex = 0; startIndex < pattern.length() && pattern.charAt(startIndex) == '/'; ++startIndex) {
            }
            while (endIndex > 0 && pattern.charAt(endIndex - 1) == '/') {
                --endIndex;
            }
            if (startIndex > 0 || endIndex < pattern.length()) {
                pattern = pattern.substring(startIndex, endIndex);
            }
            if (pattern.length() <= 0) continue;
            patternList.add(pattern);
        }
        return patternList.toArray(new String[patternList.size()]);
    }

    public PatternSet addExcludes(String[] addedExcludes) {
        ArrayHashSet excludeSet = new ArrayHashSet();
        for (String exclude : this.excludes) {
            excludeSet.add(exclude);
        }
        for (String addedExclude : addedExcludes) {
            excludeSet.add(addedExclude);
        }
        this.excludes = excludeSet.toArray(new String[excludeSet.size()]);
        return this;
    }

    public PatternSet addDefaultExcludes() {
        return this.addExcludes(FileUtil.DEFAULT_EXCLUDES);
    }

    public String[] getIncludes() {
        return this.includes;
    }

    public String[] getExcludes() {
        return this.excludes;
    }

    public boolean isEmpty() {
        return this.includes.length == 0 && this.excludes.length == 0;
    }

    public boolean isIncludeAll() {
        if (this.isExcludeAll()) {
            return false;
        }
        return this.includes.length == 1 && "**".equals(this.includes[0]) && this.excludes.length == 0;
    }

    public boolean isExcludeAll() {
        return this.excludes.length == 1 && "**".equals(this.excludes[0]);
    }

    public String toString() {
        int i;
        StringBuffer buffer = new StringBuffer();
        buffer.append("includes[");
        for (i = 0; i < this.includes.length; ++i) {
            String include = this.includes[i];
            if (i > 0) {
                buffer.append(", ");
            }
            buffer.append(include);
        }
        buffer.append("]");
        buffer.append(", excludes[");
        for (i = 0; i < this.excludes.length; ++i) {
            String exclude = this.excludes[i];
            if (i > 0) {
                buffer.append(", ");
            }
            buffer.append(exclude);
        }
        buffer.append("]");
        return buffer.toString();
    }
}

