/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.toolkit.util.enumeration;

import com.alibaba.toolkit.util.enumeration.Enum;
import com.alibaba.toolkit.util.typeconvert.ConvertChain;
import com.alibaba.toolkit.util.typeconvert.ConvertFailedException;
import com.alibaba.toolkit.util.typeconvert.Converter;

public class EnumConverter
implements Converter {
    public Object convert(Object value, ConvertChain chain) {
        Enum enumObj;
        Class targetType = chain.getTargetType();
        if (targetType.isInstance(value)) {
            return value;
        }
        if (value instanceof String && (enumObj = Enum.getEnumByName(targetType, ((String)value).trim())) != null) {
            return enumObj;
        }
        enumObj = null;
        try {
            Object enumValue = chain.getConvertManager().asTypeWithoutDefaultValue(Enum.getUnderlyingClass(targetType), value);
            enumObj = Enum.getEnumByValue(targetType, enumValue);
        }
        catch (ConvertFailedException e) {
            if (e.isDefaultValueSet() && (enumObj = Enum.getEnumByValue(targetType, e.getDefaultValue())) != null) {
                throw new ConvertFailedException(e).setDefaultValue(enumObj);
            }
            return chain.convert(value);
        }
        if (enumObj == null) {
            throw new ConvertFailedException();
        }
        return enumObj;
    }
}

