/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.toolkit.util.resourcebundle;

import com.alibaba.toolkit.util.resourcebundle.ClassLoaderResourceBundleLoader;
import com.alibaba.toolkit.util.resourcebundle.ResourceBundle;
import com.alibaba.toolkit.util.resourcebundle.ResourceBundleCreateException;
import com.alibaba.toolkit.util.resourcebundle.ResourceBundleFactory;
import com.alibaba.toolkit.util.resourcebundle.ResourceBundleLoader;
import java.io.BufferedInputStream;
import java.io.IOException;
import java.io.InputStream;

public abstract class AbstractResourceBundleFactory
extends ResourceBundleFactory {
    private final ResourceBundleLoader loader;

    public AbstractResourceBundleFactory() {
        this(new ClassLoaderResourceBundleLoader());
    }

    public AbstractResourceBundleFactory(ClassLoader classLoader) {
        this(new ClassLoaderResourceBundleLoader(classLoader));
    }

    public AbstractResourceBundleFactory(ResourceBundleLoader loader) {
        this.loader = loader;
    }

    public ResourceBundleLoader getLoader() {
        return this.loader;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ResourceBundle createBundle(String bundleName) throws ResourceBundleCreateException {
        InputStream stream = null;
        String filename = this.getFilename(bundleName);
        if (this.loader != null) {
            stream = this.loader.openStream(filename);
        }
        if (stream == null) {
            return null;
        }
        try {
            ResourceBundle resourceBundle = this.parse(new BufferedInputStream(stream), filename);
            return resourceBundle;
        }
        finally {
            try {
                stream.close();
            }
            catch (IOException e) {}
        }
    }

    protected String getFilename(String bundleName) {
        return bundleName.replace('.', '/');
    }

    protected abstract ResourceBundle parse(InputStream var1, String var2) throws ResourceBundleCreateException;

    public boolean equals(Object other) {
        if (other == this) {
            return true;
        }
        try {
            AbstractResourceBundleFactory otherFactory = (AbstractResourceBundleFactory)other;
            return this.loader == null ? otherFactory.loader == null : this.loader.equals(otherFactory.loader);
        }
        catch (NullPointerException npe) {
            return false;
        }
        catch (ClassCastException cce) {
            return false;
        }
    }

    public int hashCode() {
        return this.loader == null ? 0 : this.loader.hashCode();
    }
}

