/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.toolkit.util.typeconvert.converters;

import com.alibaba.toolkit.util.typeconvert.ConvertChain;
import com.alibaba.toolkit.util.typeconvert.ConvertFailedException;
import com.alibaba.toolkit.util.typeconvert.Converter;

public class FloatConverter
implements Converter {
    protected static final Float DEFAULT_VALUE = new Float(0.0f);

    public Object convert(Object value, ConvertChain chain) {
        if (value == null) {
            throw new ConvertFailedException().setDefaultValue(DEFAULT_VALUE);
        }
        if (value instanceof Float) {
            return value;
        }
        if (value instanceof Number) {
            return new Float(((Number)value).floatValue());
        }
        if (value instanceof String) {
            String strValue = ((String)value).trim();
            try {
                return new Float(strValue);
            }
            catch (NumberFormatException e) {
                if (strValue.length() > 0) {
                    throw new ConvertFailedException(e);
                }
                throw new ConvertFailedException().setDefaultValue(DEFAULT_VALUE);
            }
        }
        return chain.convert(value);
    }
}

