/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.toolkit.util.typeconvert.converters;

import com.alibaba.toolkit.util.typeconvert.ConvertChain;
import com.alibaba.toolkit.util.typeconvert.ConvertFailedException;
import com.alibaba.toolkit.util.typeconvert.Converter;

public class IntegerConverter
implements Converter {
    protected static final Integer DEFAULT_VALUE = new Integer(0);

    public Object convert(Object value, ConvertChain chain) {
        if (value == null) {
            throw new ConvertFailedException().setDefaultValue(DEFAULT_VALUE);
        }
        if (value instanceof Integer) {
            return value;
        }
        if (value instanceof Number) {
            return new Integer(((Number)value).intValue());
        }
        if (value instanceof String) {
            String strValue = ((String)value).trim();
            try {
                return Integer.decode(strValue);
            }
            catch (NumberFormatException e) {
                if (strValue.length() > 0) {
                    throw new ConvertFailedException(e);
                }
                throw new ConvertFailedException().setDefaultValue(DEFAULT_VALUE);
            }
        }
        return chain.convert(value);
    }
}

