/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.nacos.spring.core.env;

import com.alibaba.nacos.api.config.ConfigService;
import com.alibaba.nacos.api.config.listener.AbstractListener;
import com.alibaba.nacos.api.config.listener.Listener;
import com.alibaba.nacos.api.exception.NacosException;
import com.alibaba.nacos.spring.beans.factory.annotation.ConfigServiceBeanBuilder;
import com.alibaba.nacos.spring.context.event.config.EventPublishingConfigService;
import com.alibaba.nacos.spring.core.env.AbstractNacosPropertySourceBuilder;
import com.alibaba.nacos.spring.core.env.NacosPropertySource;
import com.alibaba.nacos.spring.factory.NacosServiceFactory;
import com.alibaba.nacos.spring.util.NacosBeanUtils;
import com.alibaba.spring.util.BeanUtils;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Properties;
import java.util.Set;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.BeanFactory;
import org.springframework.beans.factory.config.BeanDefinition;
import org.springframework.beans.factory.config.BeanFactoryPostProcessor;
import org.springframework.beans.factory.config.ConfigurableListableBeanFactory;
import org.springframework.beans.factory.support.BeanDefinitionRegistry;
import org.springframework.beans.factory.support.BeanDefinitionRegistryPostProcessor;
import org.springframework.context.EnvironmentAware;
import org.springframework.core.Ordered;
import org.springframework.core.env.ConfigurableEnvironment;
import org.springframework.core.env.Environment;
import org.springframework.core.env.MutablePropertySources;
import org.springframework.core.env.PropertySource;
import org.springframework.util.ObjectUtils;

public class NacosPropertySourcePostProcessor
implements BeanDefinitionRegistryPostProcessor,
BeanFactoryPostProcessor,
EnvironmentAware,
Ordered {
    public static final String BEAN_NAME = "nacosPropertySourcePostProcessor";
    protected static BeanFactory beanFactory;
    protected final Set<String> processedBeanNames = new LinkedHashSet<String>();
    private ConfigurableEnvironment environment;
    protected Collection<AbstractNacosPropertySourceBuilder> nacosPropertySourceBuilders;
    protected ConfigServiceBeanBuilder configServiceBeanBuilder;

    public static void addListenerIfAutoRefreshed(final NacosPropertySource nacosPropertySource, Properties properties, final ConfigurableEnvironment environment) {
        if (!nacosPropertySource.isAutoRefreshed()) {
            return;
        }
        final String dataId = nacosPropertySource.getDataId();
        final String groupId = nacosPropertySource.getGroupId();
        final String type = nacosPropertySource.getType();
        NacosServiceFactory nacosServiceFactory = NacosBeanUtils.getNacosServiceFactoryBean(beanFactory);
        try {
            ConfigService configService = nacosServiceFactory.createConfigService(properties);
            AbstractListener listener = new AbstractListener(){

                public void receiveConfigInfo(String config) {
                    String name = nacosPropertySource.getName();
                    NacosPropertySource newNacosPropertySource = new NacosPropertySource(dataId, groupId, name, config, type);
                    newNacosPropertySource.copy(nacosPropertySource);
                    MutablePropertySources propertySources = environment.getPropertySources();
                    propertySources.replace(name, (PropertySource)newNacosPropertySource);
                }
            };
            if (configService instanceof EventPublishingConfigService) {
                ((EventPublishingConfigService)configService).addListener(dataId, groupId, type, (Listener)listener);
            } else {
                configService.addListener(dataId, groupId, (Listener)listener);
            }
        }
        catch (NacosException e) {
            throw new RuntimeException("ConfigService can't add Listener with properties : " + properties, e);
        }
    }

    public void postProcessBeanDefinitionRegistry(BeanDefinitionRegistry registry) throws BeansException {
    }

    public void postProcessBeanFactory(ConfigurableListableBeanFactory beanFactory) throws BeansException {
        String[] beanNames;
        String[] abstractNacosPropertySourceBuilderBeanNames = BeanUtils.getBeanNames((ConfigurableListableBeanFactory)beanFactory, AbstractNacosPropertySourceBuilder.class);
        this.nacosPropertySourceBuilders = new ArrayList<AbstractNacosPropertySourceBuilder>(abstractNacosPropertySourceBuilderBeanNames.length);
        for (String beanName : abstractNacosPropertySourceBuilderBeanNames) {
            this.nacosPropertySourceBuilders.add((AbstractNacosPropertySourceBuilder)beanFactory.getBean(beanName, AbstractNacosPropertySourceBuilder.class));
        }
        NacosPropertySourcePostProcessor.beanFactory = beanFactory;
        this.configServiceBeanBuilder = NacosBeanUtils.getConfigServiceBeanBuilder((BeanFactory)beanFactory);
        for (String beanName : beanNames = beanFactory.getBeanDefinitionNames()) {
            this.processPropertySource(beanName, beanFactory);
        }
    }

    protected void processPropertySource(String beanName, ConfigurableListableBeanFactory beanFactory) {
        if (this.processedBeanNames.contains(beanName)) {
            return;
        }
        BeanDefinition beanDefinition = beanFactory.getBeanDefinition(beanName);
        this.doProcessPropertySource(beanName, beanDefinition);
        this.processedBeanNames.add(beanName);
    }

    protected void doProcessPropertySource(String beanName, BeanDefinition beanDefinition) {
        List<NacosPropertySource> nacosPropertySources = this.buildNacosPropertySources(beanName, beanDefinition);
        for (NacosPropertySource nacosPropertySource : nacosPropertySources) {
            this.addNacosPropertySource(nacosPropertySource);
            Properties properties = this.configServiceBeanBuilder.resolveProperties(nacosPropertySource.getAttributesMetadata());
            NacosPropertySourcePostProcessor.addListenerIfAutoRefreshed(nacosPropertySource, properties, this.environment);
        }
    }

    private List<NacosPropertySource> buildNacosPropertySources(String beanName, BeanDefinition beanDefinition) {
        for (AbstractNacosPropertySourceBuilder builder : this.nacosPropertySourceBuilders) {
            if (!builder.supports(beanDefinition)) continue;
            return builder.build(beanName, beanDefinition);
        }
        return Collections.emptyList();
    }

    private void addNacosPropertySource(NacosPropertySource nacosPropertySource) {
        boolean isRelative;
        MutablePropertySources propertySources = this.environment.getPropertySources();
        boolean first = nacosPropertySource.isFirst();
        String before = nacosPropertySource.getBefore();
        String after = nacosPropertySource.getAfter();
        boolean hasBefore = !ObjectUtils.nullSafeEquals((Object)"", (Object)before);
        boolean hasAfter = !ObjectUtils.nullSafeEquals((Object)"", (Object)after);
        boolean bl = isRelative = hasBefore || hasAfter;
        if (first) {
            propertySources.addFirst((PropertySource)nacosPropertySource);
        } else if (isRelative) {
            if (hasBefore) {
                propertySources.addBefore(before, (PropertySource)nacosPropertySource);
            }
            if (hasAfter) {
                propertySources.addAfter(after, (PropertySource)nacosPropertySource);
            }
        } else {
            propertySources.addLast((PropertySource)nacosPropertySource);
        }
    }

    public int getOrder() {
        return -2147483647;
    }

    public void setEnvironment(Environment environment) {
        this.environment = (ConfigurableEnvironment)environment;
    }
}

