/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.sdk.gateway.pop.interceptor.response;

import com.aliyun.core.http.HttpResponse;
import com.aliyun.core.logging.ClientLogger;
import com.aliyun.core.utils.AttributeMap;
import com.aliyun.core.utils.ParseUtil;
import com.aliyun.sdk.gateway.pop.exception.PopClientException;
import com.aliyun.sdk.gateway.pop.exception.PopServerException;
import com.aliyun.sdk.gateway.pop.interceptor.response.PopResInterceptor;
import darabonba.core.TeaResponse;
import darabonba.core.interceptor.InterceptorContext;
import darabonba.core.interceptor.ResponseInterceptor;
import darabonba.core.utils.CommonUtil;
import java.util.HashMap;
import java.util.Map;

public class TeaResponseInterceptor
implements ResponseInterceptor {
    private final ClientLogger logger = new ClientLogger(PopResInterceptor.class);

    public TeaResponse modifyResponse(InterceptorContext context, AttributeMap attributes) {
        this.logger.verbose("HttpResponse process begin.");
        HttpResponse httpResponse = context.httpResponse();
        TeaResponse teaResponse = new TeaResponse();
        teaResponse.setHttpResponse(httpResponse);
        teaResponse.setSuccess(CommonUtil.is2xx((Number)httpResponse.getStatusCode()));
        if (CommonUtil.isNot2xx((Number)httpResponse.getStatusCode())) {
            Object _body = ParseUtil.readAsJSON((String)httpResponse.getBodyAsString());
            Map err = CommonUtil.assertAsMap((Object)_body);
            Object requestId = CommonUtil.defaultAny(err.get("RequestId"), err.get("requestId"));
            HashMap<String, Object> errMsg = new HashMap<String, Object>();
            errMsg.put("code", CommonUtil.defaultAny(err.get("Code"), err.get("code")));
            errMsg.put("message", "code: " + httpResponse.getStatusCode() + ", " + CommonUtil.defaultAny(err.get("Message"), err.get("message")) + " request id: " + requestId + "");
            errMsg.put("statusCode", httpResponse.getStatusCode());
            errMsg.put("description", CommonUtil.defaultAny(err.get("Description"), err.get("description")));
            errMsg.put("accessDeniedDetail", CommonUtil.defaultAny(err.get("AccessDeniedDetail"), err.get("accessDeniedDetail")));
            teaResponse.setException((Exception)(CommonUtil.is5xx((Number)httpResponse.getStatusCode()) ? new PopServerException(errMsg) : new PopClientException(errMsg)));
        }
        return teaResponse;
    }
}

