package com.aliyun.sdk.gateway.pop;

import com.aliyun.auth.signature.Signer;
import com.aliyun.sdk.gateway.pop.auth.SignatureVersion;
import com.aliyun.sdk.gateway.pop.auth.signer.PopV1Signer;
import com.aliyun.sdk.gateway.pop.auth.signer.PopV3Signer;
import com.aliyun.sdk.gateway.pop.interceptor.configuration.EndpointInterceptor;
import com.aliyun.sdk.gateway.pop.interceptor.httpRequest.RoaHttpReqInterceptor;
import com.aliyun.sdk.gateway.pop.interceptor.httpRequest.RpcHttpReqInterceptor;
import com.aliyun.sdk.gateway.pop.interceptor.httpRequest.V3HttpReqInterceptor;
import com.aliyun.sdk.gateway.pop.interceptor.output.FinalizedOutputInterceptor;
import com.aliyun.sdk.gateway.pop.interceptor.request.RoaReqInterceptor;
import com.aliyun.sdk.gateway.pop.interceptor.request.RpcReqInterceptor;
import com.aliyun.sdk.gateway.pop.interceptor.request.V3ReqInterceptor;
import com.aliyun.sdk.gateway.pop.interceptor.response.PopResInterceptor;
import com.aliyun.sdk.gateway.pop.interceptor.response.TeaResponseInterceptor;
import com.aliyun.sdk.gateway.pop.policy.POPUserAgentPolicy;
import darabonba.core.TeaClientBuilder;
import darabonba.core.client.ClientConfiguration;
import darabonba.core.client.ClientOption;
import darabonba.core.client.IClientBuilder;
import darabonba.core.interceptor.InterceptorChain;
import darabonba.core.utils.CommonUtil;

public abstract class BaseClientBuilder<BuilderT extends IClientBuilder<BuilderT, ClientT>, ClientT> extends TeaClientBuilder<BuilderT, ClientT> {

    @Override
    protected String serviceName() {
        return "POP";
    }

    public BuilderT serviceConfiguration(Configuration serviceConfiguration) {
        clientConfiguration.setOption(ClientOption.SERVICE_CONFIGURATION, serviceConfiguration);
        return (BuilderT) this;
    }

    @Override
    protected ClientConfiguration mergeServiceDefaults(ClientConfiguration configuration) {
        return configuration.merge(ClientConfiguration.create()
                .setOption(ClientOption.SERVICE_CONFIGURATION, Configuration.create())
                .setOption(ClientOption.USER_AGENT_SERVICE_SUFFIX, POPUserAgentPolicy.getDefaultUserAgentSuffix()));
    }

    @Override
    protected ClientConfiguration finalizeServiceConfiguration(ClientConfiguration configuration) {
        InterceptorChain chain = InterceptorChain.create();
        chain.addConfigurationInterceptor(new EndpointInterceptor());
        chain.addRequestInterceptor(new RpcReqInterceptor());
        chain.addRequestInterceptor(new RoaReqInterceptor());
        chain.addRequestInterceptor(new V3ReqInterceptor());
        chain.addHttpRequestInterceptor(new RpcHttpReqInterceptor());
        chain.addHttpRequestInterceptor(new RoaHttpReqInterceptor());
        chain.addHttpRequestInterceptor(new V3HttpReqInterceptor());

        chain.addResponseInterceptor(new TeaResponseInterceptor());
        chain.addResponseInterceptor(new PopResInterceptor());
        chain.addOutputInterceptor(new FinalizedOutputInterceptor());
        configuration.setOption(ClientOption.INTERCEPTOR_CHAIN, chain);
        Configuration config = (Configuration) configuration.option(ClientOption.SERVICE_CONFIGURATION);
        Signer signer;
        if (CommonUtil.isUnset(config)) {
            signer = new PopV1Signer(Configuration.DEFAULT_SIGNATURE_ALGORRITHM_V1);
            config = Configuration.create();
            configuration.setOption(ClientOption.SERVICE_CONFIGURATION, config);
        } else if (config.signatureVersion() == SignatureVersion.V3) {
            signer = new PopV3Signer(config.signatureAlgorithmV3());
        } else {
            signer = new PopV1Signer(config.signatureAlgorithmV1());
        }
        configuration.setOption(ClientOption.SIGNER, signer);
        return configuration;
    }
}