package com.aliyun.sdk.gateway.pop.auth;

import com.aliyun.auth.signature.exception.SignatureException;
import com.aliyun.core.http.HttpMethod;
import com.aliyun.core.utils.EncodeUtil;
import com.aliyun.core.utils.StringUtils;

import java.io.UnsupportedEncodingException;
import java.util.*;

public class V3SignatureComposer {
    private final static String UTF8 = "UTF-8";
    private final static String SEPARATOR = "&";
    private final static String DELIMITER = ";";
    private final static String prefix = "x-acs-";
    private final static String CONTENT_TYPE = "content-type";
    private final static String HOST = "host";

    public static String composeStringToSign(HttpMethod method, Map<String, String> params,
                                             Map<String, String> headers, String pathname, String payload) {
        String canonicalURI = pathname;
        if (StringUtils.isBlank(canonicalURI)) {
            canonicalURI = "/";
        }
        String queryString = getCanonicalizedResource(params);
        StringBuilder sb = new StringBuilder(method.toString());
        sb.append("\n").append(canonicalURI)
                .append("\n").append(queryString)
                .append("\n").append(buildCanonicalizedHeaders(headers))
                .append("\n").append(buildSignedHeaders(headers))
                .append("\n").append(payload);
        return sb.toString();
    }

    private static String buildCanonicalizedHeaders(Map<String, String> headers) {
        Set<String> keys = headers.keySet();
        List<String> canonicalizedKeys = new ArrayList<>();
        Map<String, String> valueMap = new HashMap<>();
        for (String key : keys) {
            String lowerKey = key.toLowerCase();
            if (lowerKey.startsWith(prefix) || lowerKey.equals(HOST)
                    || lowerKey.equals(CONTENT_TYPE)) {
                if (!canonicalizedKeys.contains(lowerKey)) {
                    canonicalizedKeys.add(lowerKey);
                }
                valueMap.put(lowerKey, headers.get(key).trim());
            }
        }
        String[] canonicalizedKeysArray = canonicalizedKeys.toArray(new String[canonicalizedKeys.size()]);
        Arrays.sort(canonicalizedKeysArray);
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < canonicalizedKeysArray.length; i++) {
            String key = canonicalizedKeysArray[i];
            sb.append(key);
            sb.append(":");
            sb.append(valueMap.get(key));
            sb.append("\n");
        }
        return sb.toString();
    }

    public static String buildSignedHeaders(Map<String, String> headers) {
        String[] keys = headers.keySet().toArray(new String[headers.size()]);
        Arrays.sort(keys);
        List<String> canonicalizedKeys = new ArrayList<String>();
        for (String key : keys) {
            String lowerKey = key.toLowerCase();
            if (lowerKey.startsWith(prefix) || lowerKey.equals(HOST)
                    || lowerKey.equals(CONTENT_TYPE)) {
                if (!canonicalizedKeys.contains(lowerKey)) {
                    canonicalizedKeys.add(lowerKey);
                }
            }
        }
        String[] canonicalizedKeysArray = canonicalizedKeys.toArray(new String[canonicalizedKeys.size()]);
        return StringUtils.join(DELIMITER, Arrays.asList(canonicalizedKeysArray));
    }

    private static String getCanonicalizedResource(Map<String, String> query) {
        if (query == null || query.size() == 0) {
            return StringUtils.EMPTY;
        }
        String[] keys = query.keySet().toArray(new String[query.size()]);
        Arrays.sort(keys);
        StringBuilder queryString = new StringBuilder();
        try {
            for (int i = 0; i < keys.length; i++) {
                queryString.append(EncodeUtil.percentEncode(keys[i]));
                queryString.append("=");
                if (!StringUtils.isEmpty(query.get(keys[i]))) {
                    queryString.append(EncodeUtil.percentEncode(query.get(keys[i])));
                }
                queryString.append(SEPARATOR);
            }
        } catch (UnsupportedEncodingException e) {
            throw new SignatureException(e.toString());
        }
        return queryString.length() > 0 ? queryString.deleteCharAt(queryString.length() - 1).toString() : StringUtils.EMPTY;
    }


}
