package com.aliyun.sdk.gateway.pop.auth.signer;

import com.aliyun.auth.signature.SignerParams;
import com.aliyun.auth.signature.exception.SignatureException;
import com.aliyun.auth.signature.signer.SignAlgorithmHmacSHA1;
import com.aliyun.sdk.gateway.pop.auth.SignatureAlgorithm;
import com.aliyun.sdk.gateway.pop.auth.SignatureVersion;
import com.aliyun.auth.credentials.ICredential;

import javax.crypto.Mac;
import javax.crypto.spec.SecretKeySpec;
import java.io.UnsupportedEncodingException;
import java.security.InvalidKeyException;
import java.util.Base64;

public class PopV1Signer implements PopSigner {
    private final String ENCODING = "UTF-8";
    private final SignatureAlgorithm DEFAULT_ALGORITHM = SignatureAlgorithm.HMAC_SHA1;
    private final SignatureAlgorithm algorithm;

    public PopV1Signer() {
        this.algorithm = DEFAULT_ALGORITHM;
    }

    public PopV1Signer(SignatureAlgorithm algorithm) {
        if (algorithm != null) {
            this.algorithm = algorithm;
        } else {
            this.algorithm = DEFAULT_ALGORITHM;
        }
    }

    @Override
    public String signString(String stringToSign, SignerParams params) {
        switch (algorithm) {
            case HMAC_SHA1:
            default:
                try {
                    Mac mac = SignAlgorithmHmacSHA1.HmacSHA1.getMac();
                    ICredential credential = params.credentials();
                    mac.init(new SecretKeySpec(credential.accessKeySecret().getBytes(ENCODING), SignAlgorithmHmacSHA1.HmacSHA1.toString()));
                    return Base64.getEncoder().encodeToString(mac.doFinal(stringToSign.getBytes(ENCODING)));
                } catch (UnsupportedEncodingException | InvalidKeyException e) {
                    throw new SignatureException(e.toString());
                }
        }

    }

    @Override
    public byte[] hash(byte[] raw) {
        return null;
    }

    @Override
    public String getContent() {
        return null;
    }

    @Override
    public SignatureAlgorithm getSignerName() {
        return algorithm;
    }

    @Override
    public SignatureVersion getSignerVersion() {
        return SignatureVersion.V1;
    }
}
