package com.aliyun.sdk.gateway.pop.exception;

import com.aliyun.core.utils.StringUtils;
import darabonba.core.exception.ClientException;
import darabonba.core.utils.CommonUtil;

import java.lang.reflect.Field;
import java.util.HashMap;
import java.util.Map;

public class PopClientException extends ClientException {
    private String code;
    private String message;
    private String requestId;
    private String description;
    private Map<String, Object> accessDeniedDetail;
    private Map<String, Object> data;

    public PopClientException() {
        super();
    }

    public PopClientException(final String message) {
        super(message);
    }

    public PopClientException(final Throwable cause) {
        super(cause);
    }

    public PopClientException(final String message, final Throwable cause) {
        super(message, cause);
    }

    public PopClientException(final String message, final Throwable cause, final boolean enableSuppression,
                              final boolean writableStackTrace) {
        super(message, cause, enableSuppression, writableStackTrace);
    }

    public PopClientException(Map<String, Object> map) {
        setData(map);
    }

    public PopClientException(Map<String, Object> map, String message, Throwable cause) {
        super(message, cause);
        setData(map);
    }

    @Override
    public String getMessage() {
        if (!StringUtils.isEmpty(message)) {
            return "\n(Code: " + getErrCode() +
                    "\nMessage: " + getErrMessage() +
                    "\nRequest ID: " + getRequestId() + ")";
        }
        return super.getMessage();
    }

    public String getErrMessage() {
        return message;
    }

    public void setErrMessage(String message) {
        this.message = message;
    }

    public String getErrCode() {
        return code;
    }

    public void setErrCode(String code) {
        this.code = code;
    }

    public String getRequestId() {
        return requestId;
    }

    public void setRequestId(String requestId) {
        this.requestId = requestId;
    }

    public String getDescription() {
        return description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public Map<String, Object> getAccessDeniedDetail() {
        return accessDeniedDetail;
    }

    public void setAccessDeniedDetail(Map<String, Object> accessDeniedDetail) {
        this.accessDeniedDetail = accessDeniedDetail;
    }

    public Map<String, Object> getData() {
        return data;
    }

    public void setData(Map<String, Object> map) {
        this.setErrCode(String.valueOf(map.get("code")));
        this.setErrMessage(String.valueOf(map.get("message")));
        this.setDescription(String.valueOf(map.get("description")));
        if (map.containsKey("statusCode")) {
            this.setStatusCode(Integer.parseInt(String.valueOf(map.get("statusCode"))));
        }
        if (map.get("accessDeniedDetail") instanceof Map) {
            this.setAccessDeniedDetail((Map<String, Object>) map.get("accessDeniedDetail"));
        }
        Object obj = map.get("data");
        if (obj == null) {
            return;
        }
        if (obj instanceof Map) {
            data = (Map<String, Object>) obj;
            if (!CommonUtil.isUnset(data.get("RequestId"))) {
                this.setRequestId(data.get("RequestId").toString());
            } else if (!CommonUtil.isUnset(data.get("requestId"))) {
                this.setRequestId(data.get("requestId").toString());
            }
            return;
        }
        Map<String, Object> hashMap = new HashMap<String, Object>();
        Field[] declaredFields = obj.getClass().getDeclaredFields();
        for (Field field : declaredFields) {
            field.setAccessible(true);
            try {
                hashMap.put(field.getName(), field.get(obj));
            } catch (Exception e) {
                continue;
            }
        }
        this.data = hashMap;
    }
}
