package com.aliyun.sdk.gateway.pop.interceptor.output;

import com.aliyun.core.logging.ClientLogger;
import com.aliyun.core.utils.AttributeMap;
import darabonba.core.TeaModel;
import darabonba.core.TeaPair;
import darabonba.core.TeaResponse;
import darabonba.core.exception.TeaException;
import darabonba.core.interceptor.InterceptorContext;
import darabonba.core.interceptor.OutputInterceptor;
import darabonba.core.utils.CommonUtil;

import java.util.Map;

public class FinalizedOutputInterceptor implements OutputInterceptor {
    private final ClientLogger logger = new ClientLogger(FinalizedOutputInterceptor.class);

    @Override
    public TeaModel modifyOutput(InterceptorContext context, AttributeMap attributes) {
        logger.verbose("OutputModel process begin.");
        TeaResponse response = context.teaResponse();
        try {
            Map<String, ?> headers = response.httpResponse().getHeaders().toMap();
            Map<String, Object> model = CommonUtil.buildMap(
                    new TeaPair("body", response.deserializedBody()),
                    new TeaPair("headers", headers),
                    new TeaPair("statusCode", response.httpResponse().getStatusCode()));
            TeaModel.toModel(model, context.output());
        } catch (Exception e) {
            throw new TeaException(e);
        }
        return context.output();
    }
}
