package com.aliyun.sdk.gateway.pop.interceptor.request;

import com.aliyun.sdk.gateway.pop.auth.SignatureVersion;
import com.aliyun.sdk.gateway.pop.auth.signer.PopSigner;
import com.aliyun.core.http.HttpHeaders;
import com.aliyun.core.logging.ClientLogger;
import com.aliyun.core.utils.AttributeMap;
import darabonba.core.RequestStyle;
import darabonba.core.TeaConfiguration;
import darabonba.core.TeaPair;
import darabonba.core.TeaRequest;
import darabonba.core.client.ClientConfiguration;
import darabonba.core.client.ClientOption;
import darabonba.core.interceptor.InterceptorContext;
import darabonba.core.interceptor.RequestInterceptor;
import darabonba.core.policy.UserAgentPolicy;
import darabonba.core.utils.CommonUtil;

import java.util.Map;

public class RpcReqInterceptor implements RequestInterceptor {
    private final ClientLogger logger = new ClientLogger(RpcReqInterceptor.class);

    @Override
    public TeaRequest modifyRequest(InterceptorContext context, AttributeMap attributes) {
        logger.verbose("RPC request pre-process begin.");
        TeaRequest request = context.teaRequest();
        if (!request.style().equals(RequestStyle.RPC)) {
            return request;
        }
        TeaConfiguration configuration = context.configuration();
        ClientConfiguration clientConfiguration = configuration.clientConfiguration();
        PopSigner signer = (PopSigner) clientConfiguration.option(ClientOption.SIGNER);
        if (signer.getSignerVersion() != SignatureVersion.V1) {
            return request;
        }

        Map<String, String> query = CommonUtil.merge(String.class, CommonUtil.buildMap(
                new TeaPair("Action", request.action()),
                new TeaPair("Format", "JSON"),
                new TeaPair("Version", request.version())
                ),
                request.query()
        );

        Map<String, String> headers = CommonUtil.merge(String.class, CommonUtil.buildMap(
                new TeaPair("host", configuration.endpoint()),
                new TeaPair("x-acs-version", request.version()),
                new TeaPair("x-acs-action", request.action()),
                new TeaPair("user-agent", clientConfiguration.option(ClientOption.USER_AGENT))
                ),
                request.headers().toMap()
        );
        request.setQuery(query).setHeaders(new HttpHeaders(headers));
        return request;
    }
}
