/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.sdk.gateway.pop.interceptor.request;

import com.aliyun.core.http.HttpHeaders;
import com.aliyun.core.logging.ClientLogger;
import com.aliyun.core.utils.AttributeMap;
import com.aliyun.sdk.gateway.pop.auth.SignatureVersion;
import com.aliyun.sdk.gateway.pop.auth.signer.PopSigner;
import darabonba.core.TeaConfiguration;
import darabonba.core.TeaPair;
import darabonba.core.TeaRequest;
import darabonba.core.client.ClientConfiguration;
import darabonba.core.client.ClientOption;
import darabonba.core.interceptor.InterceptorContext;
import darabonba.core.interceptor.RequestInterceptor;
import darabonba.core.utils.CommonUtil;
import java.util.Map;

public class V3ReqInterceptor
implements RequestInterceptor {
    private final ClientLogger logger = new ClientLogger(V3ReqInterceptor.class);

    public TeaRequest modifyRequest(InterceptorContext context, AttributeMap attributes) {
        this.logger.verbose("Request pre-process begin.");
        TeaRequest request = context.teaRequest();
        TeaConfiguration configuration = context.configuration();
        ClientConfiguration clientConfiguration = configuration.clientConfiguration();
        PopSigner signer = (PopSigner)clientConfiguration.option(ClientOption.SIGNER);
        if (signer.getSignerVersion() != SignatureVersion.V3) {
            return request;
        }
        Map headers = CommonUtil.merge(String.class, (Object[])new Object[]{CommonUtil.buildMap((TeaPair[])new TeaPair[]{new TeaPair("host", (Object)configuration.endpoint()), new TeaPair("accept", (Object)"application/json"), new TeaPair("x-acs-version", (Object)request.version()), new TeaPair("x-acs-action", (Object)request.action()), new TeaPair("user-agent", clientConfiguration.option(ClientOption.USER_AGENT))}), request.headers().toMap()});
        request.setHeaders(new HttpHeaders(headers));
        return request;
    }
}

