/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.httpcomponent.httpclient;

import com.aliyun.core.http.HttpClient;
import com.aliyun.core.http.HttpHeader;
import com.aliyun.core.http.HttpHeaders;
import com.aliyun.core.http.HttpRequest;
import com.aliyun.core.http.HttpResponse;
import com.aliyun.core.http.HttpResponseHandler;
import com.aliyun.core.http.ProxyOptions;
import com.aliyun.core.logging.ClientLogger;
import com.aliyun.core.utils.BinaryUtils;
import com.aliyun.core.utils.Context;
import com.aliyun.core.utils.StringUtils;
import com.aliyun.httpcomponent.httpclient.implementation.ApacheAsyncHttpResponse;
import com.aliyun.httpcomponent.httpclient.implementation.StreamRequestProducer;
import com.aliyun.httpcomponent.httpclient.implementation.reactive.ReactiveApacheHttpResponse;
import com.aliyun.httpcomponent.httpclient.implementation.reactive.ReactiveHttpResponse;
import com.aliyun.httpcomponent.httpclient.implementation.reactive.ReactiveResponseConsumer;
import java.net.InetSocketAddress;
import java.net.URISyntaxException;
import java.nio.ByteBuffer;
import java.time.Duration;
import java.util.Objects;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import org.apache.hc.client5.http.async.methods.SimpleHttpRequest;
import org.apache.hc.client5.http.async.methods.SimpleHttpResponse;
import org.apache.hc.client5.http.async.methods.SimpleRequestBuilder;
import org.apache.hc.client5.http.async.methods.SimpleResponseConsumer;
import org.apache.hc.client5.http.config.RequestConfig;
import org.apache.hc.client5.http.impl.async.CloseableHttpAsyncClient;
import org.apache.hc.core5.concurrent.FutureCallback;
import org.apache.hc.core5.http.ContentType;
import org.apache.hc.core5.http.HttpHost;
import org.apache.hc.core5.http.nio.AsyncRequestProducer;
import org.apache.hc.core5.io.CloseMode;
import org.apache.hc.core5.util.TimeValue;
import org.apache.hc.core5.util.Timeout;

class ApacheAsyncHttpClient
implements HttpClient {
    private final String RESPONSE_HANDLER_KEY = "RESPONSE_HANDLER";
    private final ClientLogger logger = new ClientLogger(ApacheAsyncHttpClient.class);
    private final CloseableHttpAsyncClient apacheHttpAsyncClient;
    private final Timeout connectTimeout;
    private final long connectionKeepAlive;

    ApacheAsyncHttpClient(CloseableHttpAsyncClient apacheHttpAsyncClient, Timeout connectTimeout, long connectionKeepAlive) {
        this.apacheHttpAsyncClient = apacheHttpAsyncClient;
        this.connectTimeout = connectTimeout;
        this.connectionKeepAlive = connectionKeepAlive;
    }

    public CompletableFuture<HttpResponse> send(HttpRequest request) {
        return this.send(request, Context.NONE);
    }

    public CompletableFuture<HttpResponse> send(HttpRequest request, Context context) {
        this.apacheHttpAsyncClient.start();
        if (request.getStreamBody() != null) {
            if (context.getData((Object)"RESPONSE_HANDLER").isPresent()) {
                return this.sendV3(request, context);
            }
            return this.sendV2(request, context);
        }
        return this.sendV1(request, context);
    }

    public void close() {
        if (this.apacheHttpAsyncClient != null) {
            this.apacheHttpAsyncClient.close(CloseMode.GRACEFUL);
        }
    }

    private SimpleHttpRequest toApacheAsyncRequest(HttpRequest request) throws URISyntaxException, ExecutionException, InterruptedException {
        String[] ct;
        SimpleRequestBuilder apacheRequestBuilder = SimpleRequestBuilder.create(request.getHttpMethod().toString()).setUri(request.getUrl().toURI());
        HttpHeaders headers = request.getHeaders();
        for (HttpHeader httpHeader : headers) {
            apacheRequestBuilder.setHeader(httpHeader.getName(), httpHeader.getValue());
        }
        switch (request.getHttpMethod()) {
            case GET: 
            case HEAD: 
            case DELETE: {
                return apacheRequestBuilder.build();
            }
        }
        ContentType type = StringUtils.isEmpty((CharSequence)headers.getValue("content-type")) ? ContentType.APPLICATION_FORM_URLENCODED : ((ct = headers.getValue("content-type").split(";")).length > 1 ? ContentType.create(ct[0].trim(), ct[1].replace("charset=", "").trim()) : ContentType.create(ct[0].trim()));
        if (request.getBody() != null) {
            apacheRequestBuilder.setBody(BinaryUtils.copyAllBytesFrom((ByteBuffer)request.getBody()), type);
        }
        return apacheRequestBuilder.build();
    }

    private CompletableFuture<HttpResponse> sendV1(HttpRequest request, Context context) {
        SimpleHttpRequest apacheRequest;
        Objects.requireNonNull(request.getHttpMethod(), "'request.getHttpMethod()' cannot be null.");
        Objects.requireNonNull(request.getUrl(), "'request.getUrl()' cannot be null.");
        Objects.requireNonNull(request.getUrl().getProtocol(), "'request.getUrl().getProtocol()' cannot be null.");
        try {
            apacheRequest = this.toApacheAsyncRequest(request);
        }
        catch (InterruptedException | URISyntaxException | ExecutionException e) {
            throw this.logger.logExceptionAsWarning((RuntimeException)new IllegalArgumentException("'url' must can convert to a valid URI", e));
        }
        apacheRequest.setConfig(new ApacheIndividualRequestBuilder(request, this.connectTimeout, this.connectionKeepAlive).build());
        final CompletableFuture cf = new CompletableFuture();
        Future<SimpleHttpResponse> future = this.apacheHttpAsyncClient.execute(apacheRequest, new FutureCallback<SimpleHttpResponse>(){

            @Override
            public void completed(SimpleHttpResponse response) {
                cf.complete(response);
            }

            @Override
            public void failed(Exception ex) {
                cf.completeExceptionally(ex);
            }

            @Override
            public void cancelled() {
                cf.cancel(true);
            }
        });
        return cf.thenApply(simpleHttpResponse -> new ApacheAsyncHttpResponse(request, (SimpleHttpResponse)simpleHttpResponse));
    }

    private AsyncRequestProducer toApacheRequestProducer(HttpRequest request) throws URISyntaxException {
        SimpleRequestBuilder apacheRequestBuilder = SimpleRequestBuilder.create(request.getHttpMethod().toString()).setUri(request.getUrl().toURI());
        HttpHeaders headers = request.getHeaders();
        for (HttpHeader httpHeader : headers) {
            apacheRequestBuilder.setHeader(httpHeader.getName(), httpHeader.getValue());
        }
        SimpleHttpRequest simpleHttpRequest = apacheRequestBuilder.build();
        return StreamRequestProducer.create(simpleHttpRequest, request.getStreamBody());
    }

    private CompletableFuture<HttpResponse> sendV2(HttpRequest request, Context context) {
        AsyncRequestProducer apacheRequestProducer;
        Objects.requireNonNull(request.getHttpMethod(), "'request.getHttpMethod()' cannot be null.");
        Objects.requireNonNull(request.getUrl(), "'request.getUrl()' cannot be null.");
        Objects.requireNonNull(request.getUrl().getProtocol(), "'request.getUrl().getProtocol()' cannot be null.");
        try {
            apacheRequestProducer = this.toApacheRequestProducer(request);
        }
        catch (URISyntaxException e) {
            throw this.logger.logExceptionAsWarning((RuntimeException)new IllegalArgumentException("'url' must can convert to a valid URI", e));
        }
        final CompletableFuture cf = new CompletableFuture();
        Future<SimpleHttpResponse> future = this.apacheHttpAsyncClient.execute(apacheRequestProducer, SimpleResponseConsumer.create(), new FutureCallback<SimpleHttpResponse>(){

            @Override
            public void completed(SimpleHttpResponse response) {
                cf.complete(response);
            }

            @Override
            public void failed(Exception ex) {
                cf.completeExceptionally(ex);
            }

            @Override
            public void cancelled() {
                cf.cancel(true);
            }
        });
        return cf.thenApply(simpleHttpResponse -> new ApacheAsyncHttpResponse(request, (SimpleHttpResponse)simpleHttpResponse));
    }

    private CompletableFuture<HttpResponse> sendV3(HttpRequest request, Context context) {
        AsyncRequestProducer apacheRequestProducer;
        Objects.requireNonNull(request.getHttpMethod(), "'request.getHttpMethod()' cannot be null.");
        Objects.requireNonNull(request.getUrl(), "'request.getUrl()' cannot be null.");
        Objects.requireNonNull(request.getUrl().getProtocol(), "'request.getUrl().getProtocol()' cannot be null.");
        try {
            apacheRequestProducer = this.toApacheRequestProducer(request);
        }
        catch (URISyntaxException e) {
            throw this.logger.logExceptionAsWarning((RuntimeException)new IllegalArgumentException("'url' must can convert to a valid URI", e));
        }
        final CompletableFuture cf = new CompletableFuture();
        Future<ReactiveApacheHttpResponse> future = this.apacheHttpAsyncClient.execute(apacheRequestProducer, new ReactiveResponseConsumer((HttpResponseHandler)context.getData((Object)"RESPONSE_HANDLER").get()), new FutureCallback<ReactiveApacheHttpResponse>(){

            @Override
            public void completed(ReactiveApacheHttpResponse response) {
                cf.complete(response);
            }

            @Override
            public void failed(Exception ex) {
                cf.completeExceptionally(ex);
            }

            @Override
            public void cancelled() {
                cf.cancel(true);
            }
        });
        return cf.thenApply(reactiveHttpResponse -> new ReactiveHttpResponse(request, (ReactiveApacheHttpResponse)reactiveHttpResponse));
    }

    private static final class ApacheIndividualRequestBuilder {
        private final ClientLogger logger = new ClientLogger(ApacheIndividualRequestBuilder.class);
        private final HttpRequest request;
        private final RequestConfig.Builder requestConfigBuilder = RequestConfig.custom();
        private final Timeout connectTimeout;
        private final long connectionKeepAlive;

        public ApacheIndividualRequestBuilder(HttpRequest request, Timeout connectTimeout, long connectionKeepAlive) {
            this.request = request;
            this.connectTimeout = connectTimeout;
            this.connectionKeepAlive = connectionKeepAlive;
        }

        ApacheIndividualRequestBuilder setConnectTimeout() {
            if (this.request.getConnectTimeout() != null) {
                this.requestConfigBuilder.setConnectTimeout(this.duration2Timeout(this.request.getConnectTimeout()));
            } else {
                this.requestConfigBuilder.setConnectTimeout(this.connectTimeout);
            }
            return this;
        }

        ApacheIndividualRequestBuilder setResponseTimeout() {
            if (this.request.getResponseTimeout() != null) {
                this.requestConfigBuilder.setResponseTimeout(this.duration2Timeout(this.request.getResponseTimeout()));
            }
            return this;
        }

        ApacheIndividualRequestBuilder setProxy() {
            ProxyOptions proxyOptions = this.request.getProxyOptions();
            if (proxyOptions != null && proxyOptions.getType() == ProxyOptions.Type.HTTP) {
                if (proxyOptions.getNonProxyHosts() == null || !proxyOptions.getNonProxyHosts().contains(this.request.getUrl().getHost())) {
                    InetSocketAddress inetSocketAddress = proxyOptions.getAddress();
                    this.requestConfigBuilder.setProxy(new HttpHost(proxyOptions.getScheme(), inetSocketAddress.getAddress(), inetSocketAddress.getHostString(), inetSocketAddress.getPort()));
                } else {
                    this.requestConfigBuilder.setProxy(null);
                }
            }
            return this;
        }

        RequestConfig build() {
            this.setConnectTimeout().setResponseTimeout().setProxy();
            return this.requestConfigBuilder.setConnectionKeepAlive(TimeValue.of(this.connectionKeepAlive, TimeUnit.MILLISECONDS)).build();
        }

        private Timeout duration2Timeout(Duration duration) {
            return Timeout.ofMilliseconds(duration.toMillis());
        }
    }
}

