/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.httpcomponent.httpclient;

import com.aliyun.core.http.HttpClient;
import com.aliyun.core.http.ProxyOptions;
import com.aliyun.core.logging.ClientLogger;
import com.aliyun.core.utils.Configuration;
import com.aliyun.httpcomponent.httpclient.ApacheAsyncHttpClient;
import com.aliyun.httpcomponent.httpclient.implementation.CompositeX509TrustManager;
import com.aliyun.httpcomponent.httpclient.implementation.SdkConnectionKeepAliveStrategy;
import java.net.InetSocketAddress;
import java.security.KeyStore;
import java.time.Duration;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Objects;
import java.util.concurrent.TimeUnit;
import javax.net.ssl.HostnameVerifier;
import javax.net.ssl.KeyManager;
import javax.net.ssl.SSLContext;
import javax.net.ssl.TrustManager;
import javax.net.ssl.TrustManagerFactory;
import javax.net.ssl.X509TrustManager;
import org.apache.hc.client5.http.ConnectionKeepAliveStrategy;
import org.apache.hc.client5.http.auth.AuthScope;
import org.apache.hc.client5.http.auth.CredentialsProvider;
import org.apache.hc.client5.http.config.RequestConfig;
import org.apache.hc.client5.http.impl.async.HttpAsyncClientBuilder;
import org.apache.hc.client5.http.impl.async.HttpAsyncClients;
import org.apache.hc.client5.http.impl.auth.CredentialsProviderBuilder;
import org.apache.hc.client5.http.impl.nio.PoolingAsyncClientConnectionManager;
import org.apache.hc.client5.http.impl.nio.PoolingAsyncClientConnectionManagerBuilder;
import org.apache.hc.client5.http.ssl.ClientTlsStrategyBuilder;
import org.apache.hc.client5.http.ssl.DefaultHostnameVerifier;
import org.apache.hc.client5.http.ssl.NoopHostnameVerifier;
import org.apache.hc.core5.http.HttpHost;
import org.apache.hc.core5.http.impl.DefaultConnectionReuseStrategy;
import org.apache.hc.core5.http.nio.ssl.TlsStrategy;
import org.apache.hc.core5.reactor.IOReactorConfig;
import org.apache.hc.core5.util.Timeout;

public class ApacheAsyncHttpClientBuilder {
    private final ClientLogger logger = new ClientLogger(ApacheAsyncHttpClientBuilder.class);
    private HttpAsyncClientBuilder httpAsyncClientBuilder;
    private Duration connectionTimeout;
    private Duration responseTimeout;
    private Duration maxIdleTimeOut;
    private Duration keepAlive;
    private int maxConnections = 128;
    private int maxConnectionsPerRoute = 128;
    private Duration connectRequestTimeout;
    private ProxyOptions proxyOptions = null;
    private Configuration configuration;
    private static final long DEFAULT_TIMEOUT = TimeUnit.SECONDS.toMillis(20L);
    private static final long DEFAULT_KEEP_ALIVE = TimeUnit.SECONDS.toMillis(20L);
    private static final long DEFAULT_MAX_CONN_TIMEOUT = TimeUnit.SECONDS.toMillis(10L);
    private static final long DEFAULT_MAX_RESPONSE_TIMEOUT = TimeUnit.SECONDS.toMillis(20L);
    private static final long DEFAULT_MINIMUM_TIMEOUT = TimeUnit.MILLISECONDS.toMillis(1L);
    private static final long DEFAULT_CONNECT_REQUEST_TIMEOUT = TimeUnit.SECONDS.toMillis(30L);
    private static final long DEFAULT_MAX_IDLE_TIMEOUT = TimeUnit.SECONDS.toMillis(30L);
    private X509TrustManager[] x509TrustManagers = null;
    private KeyManager[] keyManagers = null;
    private HostnameVerifier hostnameVerifier = null;
    private boolean ignoreSSL = false;

    public ApacheAsyncHttpClientBuilder() {
        this.httpAsyncClientBuilder = HttpAsyncClients.custom();
    }

    public ApacheAsyncHttpClientBuilder(HttpAsyncClientBuilder httpAsyncClientBuilder) {
        this.httpAsyncClientBuilder = Objects.requireNonNull(httpAsyncClientBuilder, "'httpAsyncClientBuilder' cannot be null.");
    }

    public ApacheAsyncHttpClientBuilder connectionTimeout(Duration connectionTimeout) {
        this.connectionTimeout = connectionTimeout;
        return this;
    }

    public ApacheAsyncHttpClientBuilder responseTimeout(Duration responseTimeout) {
        this.responseTimeout = responseTimeout;
        return this;
    }

    public ApacheAsyncHttpClientBuilder maxIdleTimeOut(Duration maxIdleTimeOut) {
        this.maxIdleTimeOut = maxIdleTimeOut;
        return this;
    }

    public ApacheAsyncHttpClientBuilder keepAlive(Duration keepAlive) {
        this.keepAlive = keepAlive;
        return this;
    }

    public ApacheAsyncHttpClientBuilder maxConnections(int maxConnections) {
        this.maxConnections = maxConnections;
        return this;
    }

    public ApacheAsyncHttpClientBuilder maxConnectionsPerRoute(int maxConnectionsPerRoute) {
        this.maxConnectionsPerRoute = maxConnectionsPerRoute;
        return this;
    }

    public ApacheAsyncHttpClientBuilder connectRequestTimeout(Duration connectRequestTimeout) {
        this.connectRequestTimeout = connectRequestTimeout;
        return this;
    }

    public ApacheAsyncHttpClientBuilder proxy(ProxyOptions proxyOptions) {
        this.proxyOptions = proxyOptions;
        return this;
    }

    public ApacheAsyncHttpClientBuilder configuration(Configuration configuration) {
        this.configuration = configuration;
        return this;
    }

    public ApacheAsyncHttpClientBuilder x509TrustManagers(X509TrustManager[] x509TrustManagers) {
        this.x509TrustManagers = x509TrustManagers;
        return this;
    }

    public ApacheAsyncHttpClientBuilder keyManagers(KeyManager[] keyManagers) {
        this.keyManagers = keyManagers;
        return this;
    }

    public ApacheAsyncHttpClientBuilder hostnameVerifier(HostnameVerifier hostnameVerifier) {
        this.hostnameVerifier = hostnameVerifier;
        return this;
    }

    public ApacheAsyncHttpClientBuilder ignoreSSL(boolean ignoreSSL) {
        this.ignoreSSL = ignoreSSL;
        return this;
    }

    public HttpClient build() {
        Configuration buildConfiguration;
        this.httpAsyncClientBuilder.setDefaultRequestConfig(this.defaultRequestConfig());
        this.httpAsyncClientBuilder.setConnectionManager(this.connectionPoolConfig());
        Configuration configuration = buildConfiguration = this.configuration == null ? Configuration.getGlobalConfiguration() : this.configuration;
        if (this.proxyOptions == null && buildConfiguration != Configuration.NONE) {
            this.proxyOptions = ProxyOptions.fromConfiguration((Configuration)buildConfiguration);
        }
        if (this.proxyOptions != null) {
            InetSocketAddress inetSocketAddress = this.proxyOptions.getAddress();
            ProxyOptions.Type type = this.proxyOptions.getType();
            switch (type) {
                case SOCKS4: 
                case SOCKS5: {
                    IOReactorConfig.Builder config = IOReactorConfig.custom().setSocksProxyAddress(inetSocketAddress);
                    if (this.proxyOptions.getUsername() != null) {
                        config.setSocksProxyUsername(this.proxyOptions.getUsername()).setSocksProxyPassword(this.proxyOptions.getPassword());
                    }
                    this.httpAsyncClientBuilder.setIOReactorConfig(config.build());
                    break;
                }
                default: {
                    this.httpAsyncClientBuilder.setProxy(new HttpHost(this.proxyOptions.getScheme(), inetSocketAddress.getAddress(), inetSocketAddress.getHostString(), inetSocketAddress.getPort()));
                }
            }
            if (this.proxyOptions.getUsername() != null) {
                CredentialsProvider credentialsProvider = CredentialsProviderBuilder.create().add(new AuthScope(this.proxyOptions.getAddress().getHostString(), this.proxyOptions.getAddress().getPort()), this.proxyOptions.getUsername(), this.proxyOptions.getPassword().toCharArray()).build();
                this.httpAsyncClientBuilder.setDefaultCredentialsProvider(credentialsProvider);
            }
        }
        this.httpAsyncClientBuilder.setConnectionReuseStrategy(DefaultConnectionReuseStrategy.INSTANCE).setKeepAliveStrategy(this.buildKeepAliveStrategy()).evictIdleConnections(ApacheAsyncHttpClientBuilder.getTimeoutMillis(this.maxIdleTimeOut, "idle")).evictExpiredConnections().disableRedirectHandling().disableAutomaticRetries().setUserAgent("");
        return new ApacheAsyncHttpClient(this.httpAsyncClientBuilder.build(), ApacheAsyncHttpClientBuilder.getTimeoutMillis(this.connectionTimeout, "connect"), this.keepAlive == null ? DEFAULT_KEEP_ALIVE : this.keepAlive.toMillis());
    }

    private PoolingAsyncClientConnectionManager connectionPoolConfig() {
        PoolingAsyncClientConnectionManagerBuilder cmb = PoolingAsyncClientConnectionManagerBuilder.create();
        ArrayList<TrustManager> trustManagerList = new ArrayList<TrustManager>();
        X509TrustManager[] trustManagers = this.x509TrustManagers;
        if (null != trustManagers) {
            trustManagerList.addAll(Arrays.asList(trustManagers));
        }
        TrustManagerFactory tmf = null;
        try {
            tmf = TrustManagerFactory.getInstance(TrustManagerFactory.getDefaultAlgorithm());
            tmf.init((KeyStore)null);
            trustManagerList.addAll(Arrays.asList(tmf.getTrustManagers()));
        }
        catch (Exception e) {
            throw this.logger.logExceptionAsError(new RuntimeException(e));
        }
        ArrayList<X509TrustManager> finalTrustManagerList = new ArrayList<X509TrustManager>();
        for (TrustManager tm : trustManagerList) {
            if (!(tm instanceof X509TrustManager)) continue;
            finalTrustManagerList.add((X509TrustManager)tm);
        }
        CompositeX509TrustManager compositeX509TrustManager = new CompositeX509TrustManager(finalTrustManagerList);
        compositeX509TrustManager.setIgnoreSSLCert(this.ignoreSSL);
        KeyManager[] keyManagers = null;
        if (this.keyManagers != null) {
            keyManagers = this.keyManagers;
        }
        SSLContext sslContext = null;
        try {
            sslContext = SSLContext.getInstance("TLS");
            sslContext.init(keyManagers, new TrustManager[]{compositeX509TrustManager}, null);
        }
        catch (Exception e) {
            throw this.logger.logExceptionAsError(new RuntimeException(e));
        }
        HostnameVerifier hostnameVerifier = null;
        hostnameVerifier = this.ignoreSSL ? new NoopHostnameVerifier() : (this.hostnameVerifier != null ? this.hostnameVerifier : new DefaultHostnameVerifier());
        TlsStrategy tlsStrategy = ClientTlsStrategyBuilder.create().setSslContext(sslContext).setHostnameVerifier(hostnameVerifier).build();
        cmb.setTlsStrategy(tlsStrategy);
        PoolingAsyncClientConnectionManager cm = cmb.setMaxConnTotal(ApacheAsyncHttpClientBuilder.getMaxConnTotal(this.maxConnections)).setMaxConnPerRoute(ApacheAsyncHttpClientBuilder.getMaxConnTotal(this.maxConnectionsPerRoute)).build();
        return cm;
    }

    private RequestConfig defaultRequestConfig() {
        RequestConfig.Builder requestConfigBuilder = RequestConfig.custom().setConnectionRequestTimeout(ApacheAsyncHttpClientBuilder.getTimeoutMillis(this.connectRequestTimeout, "connectionRequest")).setConnectTimeout(ApacheAsyncHttpClientBuilder.getTimeoutMillis(this.connectionTimeout, "connect")).setResponseTimeout(ApacheAsyncHttpClientBuilder.getTimeoutMillis(this.responseTimeout, "response")).setDefaultKeepAlive(this.keepAlive == null ? DEFAULT_KEEP_ALIVE : this.keepAlive.toMillis(), TimeUnit.MILLISECONDS);
        return requestConfigBuilder.setRedirectsEnabled(false).build();
    }

    private static Timeout getTimeoutMillis(Duration timeout, String name) {
        if (timeout == null) {
            switch (name) {
                case "idle": {
                    return Timeout.ofMilliseconds(DEFAULT_MAX_IDLE_TIMEOUT);
                }
                case "connect": {
                    return Timeout.ofMilliseconds(DEFAULT_MAX_CONN_TIMEOUT);
                }
                case "response": {
                    return Timeout.ofMilliseconds(DEFAULT_MAX_RESPONSE_TIMEOUT);
                }
                case "connectionRequest": {
                    return Timeout.ofMilliseconds(DEFAULT_CONNECT_REQUEST_TIMEOUT);
                }
            }
            return Timeout.ofMilliseconds(DEFAULT_TIMEOUT);
        }
        if (timeout.isZero() || timeout.isNegative()) {
            return Timeout.ofMilliseconds(0L);
        }
        return Timeout.ofMilliseconds(Math.max(timeout.toMillis(), DEFAULT_MINIMUM_TIMEOUT));
    }

    private static int getMaxConnTotal(int maxConnTotal) {
        if (maxConnTotal <= 0) {
            return Runtime.getRuntime().availableProcessors() * 10;
        }
        return maxConnTotal;
    }

    private ConnectionKeepAliveStrategy buildKeepAliveStrategy() {
        long maxIdle = ApacheAsyncHttpClientBuilder.getTimeoutMillis(this.maxIdleTimeOut, "idle").toMilliseconds();
        return maxIdle > 0L ? new SdkConnectionKeepAliveStrategy(maxIdle) : null;
    }
}

