/*
 * Decompiled with CFR 0.152.
 */
package darabonba.core.policy.retry.conditions;

import darabonba.core.policy.retry.RetryPolicyContext;
import darabonba.core.policy.retry.conditions.RetryCondition;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.Set;

public final class OrRetryCondition
implements RetryCondition {
    private final Set<RetryCondition> conditions = new LinkedHashSet<RetryCondition>();

    private OrRetryCondition(RetryCondition ... conditions) {
        Collections.addAll(this.conditions, conditions);
    }

    public static OrRetryCondition create(RetryCondition ... conditions) {
        return new OrRetryCondition(conditions);
    }

    @Override
    public boolean shouldRetry(RetryPolicyContext context) {
        return this.conditions.stream().anyMatch(r -> r.shouldRetry(context));
    }

    @Override
    public void requestWillNotBeRetried(RetryPolicyContext context) {
        this.conditions.forEach(c -> c.requestWillNotBeRetried(context));
    }

    @Override
    public void requestSucceeded(RetryPolicyContext context) {
        this.conditions.forEach(c -> c.requestSucceeded(context));
    }
}

