/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.hitsdb.client.util;

import com.aliyun.hitsdb.client.util.HealthWatcher;
import com.aliyun.hitsdb.client.util.HttpUtil;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HealthManager {
    private static final Logger LOG = LoggerFactory.getLogger(HealthManager.class);
    private ConcurrentMap<String, HealthWatcher> watchers = new ConcurrentHashMap<String, HealthWatcher>();
    private ScheduledExecutorService executorService = Executors.newSingleThreadScheduledExecutor();
    private int intervalSeconds = 2;
    public static final String OK = "OK";

    public void start() {
        if (this.intervalSeconds > 0) {
            this.executorService.scheduleWithFixedDelay(new WatchRunnable(), this.intervalSeconds, this.intervalSeconds, TimeUnit.SECONDS);
        }
    }

    public void stop() {
        this.executorService.shutdown();
    }

    public void setIntervalSeconds(int intervalSeconds) {
        this.intervalSeconds = intervalSeconds;
    }

    public void watch(String host, HealthWatcher watcher) {
        this.watchers.put(host, watcher);
    }

    public void unWatch(String host) {
        this.watchers.remove(host);
    }

    public boolean healthCheck(String host) {
        if (!host.startsWith("http")) {
            host = "http://" + host;
        }
        String url = host + "/api/vip_health";
        if (LOG.isDebugEnabled()) {
            LOG.debug("start to check {} ", (Object)host);
        }
        try {
            String result = HttpUtil.get(url);
            if (result.isEmpty()) {
                return false;
            }
            if (OK.equals(result.toUpperCase())) {
                if (LOG.isDebugEnabled()) {
                    LOG.debug("the host:{} work well", (Object)host);
                }
                return true;
            }
            LOG.warn("the host :{} is not work well", (Object)host);
            return false;
        }
        catch (Exception e) {
            LOG.warn("the host {} maybe not health, so will be remove", (Object)host, (Object)e);
            return false;
        }
    }

    private final class WatchRunnable
    implements Runnable {
        private WatchRunnable() {
        }

        @Override
        public void run() {
            try {
                LOG.info("start to run health check");
                long start = System.currentTimeMillis();
                for (Map.Entry entry : HealthManager.this.watchers.entrySet()) {
                    String host = (String)entry.getKey();
                    HealthWatcher watcher = (HealthWatcher)entry.getValue();
                    watcher.health(host, HealthManager.this.healthCheck(host));
                }
                LOG.info("finished run health check,cost {}ms", (Object)(System.currentTimeMillis() - start));
            }
            catch (Exception e) {
                LOG.error("when run health check error", (Throwable)e);
            }
        }
    }
}

