/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.hitsdb.client.value.request;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.alibaba.fastjson.parser.DefaultJSONParser;
import com.alibaba.fastjson.parser.deserializer.ObjectDeserializer;
import com.alibaba.fastjson.serializer.JSONSerializer;
import com.alibaba.fastjson.serializer.ObjectSerializer;
import com.aliyun.hitsdb.client.value.request.ByteArrayValue;
import com.aliyun.hitsdb.client.value.request.ComplexValue;
import com.aliyun.hitsdb.client.value.request.GeoPointValue;
import java.io.IOException;
import java.lang.reflect.Type;
import java.util.HashMap;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FieldsSerializer
implements ObjectSerializer,
ObjectDeserializer {
    static final Logger log = LoggerFactory.getLogger(FieldsSerializer.class);

    public Map<String, Object> deserialze(DefaultJSONParser parser, Type type, Object fieldName) {
        Object parse = parser.parse();
        if (parse == null) {
            return null;
        }
        if (parse instanceof JSONObject) {
            for (Map.Entry entry : ((JSONObject)parse).entrySet()) {
                JSONObject jsonObject;
                if (!(entry.getValue() instanceof JSONObject) || !ComplexValue.isJsonObjectTypeMatch(jsonObject = (JSONObject)entry.getValue())) continue;
                String valueType = jsonObject.getString("type");
                if ("bytes".equals(valueType)) {
                    ByteArrayValue bv = (ByteArrayValue)JSON.parseObject((String)jsonObject.toJSONString(), ByteArrayValue.class);
                    entry.setValue(bv.decode());
                    continue;
                }
                if ("geopoint".equals(valueType)) {
                    GeoPointValue gp = (GeoPointValue)JSON.parseObject((String)jsonObject.toJSONString(), GeoPointValue.class);
                    entry.setValue(gp);
                    continue;
                }
                log.error("Illegal value type {}", (Object)valueType);
                throw new IllegalArgumentException("Illegal value type " + valueType);
            }
        }
        return (Map)parse;
    }

    public void write(JSONSerializer serializer, Object object, Object fieldName, Type fieldType, int features) throws IOException {
        Map map = (Map)object;
        HashMap original = new HashMap();
        for (Map.Entry entry : map.entrySet()) {
            if (!(entry.getValue() instanceof byte[])) continue;
            Object value = entry.getValue();
            ByteArrayValue bv = new ByteArrayValue((byte[])value);
            entry.setValue(bv);
            original.put(entry.getKey(), value);
        }
        serializer.write((Object)map);
        for (Map.Entry entry : original.entrySet()) {
            map.put(entry.getKey(), entry.getValue());
        }
    }

    public int getFastMatchToken() {
        return 0;
    }
}

