/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.hitsdb.client.value.request;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.annotation.JSONField;
import com.alibaba.fastjson.serializer.SerializerFeature;
import com.aliyun.hitsdb.client.callback.AbstractBatchPutCallback;
import com.aliyun.hitsdb.client.callback.AbstractMultiFieldBatchPutCallback;
import com.aliyun.hitsdb.client.util.Objects;
import com.aliyun.hitsdb.client.value.request.AbstractPoint;
import com.aliyun.hitsdb.client.value.request.MultiFieldPoint;
import com.aliyun.hitsdb.client.value.request.Point;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public class PointsCollection
extends ArrayList<AbstractPoint> {
    @JSONField(serialize=false)
    private final AbstractBatchPutCallback simplePointBatchCallbak;
    @JSONField(serialize=false)
    private final AbstractMultiFieldBatchPutCallback multiFieldBatchPutCallback;

    public PointsCollection(Collection<Point> points, AbstractBatchPutCallback callback) {
        Objects.requireNonNull(points);
        Objects.requireNonNull(callback);
        this.addAll(points);
        this.simplePointBatchCallbak = callback;
        this.multiFieldBatchPutCallback = null;
    }

    public PointsCollection(Collection<MultiFieldPoint> multiFieldPoints, AbstractMultiFieldBatchPutCallback callback) {
        Objects.requireNonNull(multiFieldPoints);
        Objects.requireNonNull(callback);
        this.addAll(multiFieldPoints);
        this.simplePointBatchCallbak = null;
        this.multiFieldBatchPutCallback = callback;
    }

    public AbstractBatchPutCallback getSimplePointBatchCallbak() {
        return this.simplePointBatchCallbak;
    }

    public AbstractMultiFieldBatchPutCallback getMultiFieldBatchPutCallback() {
        return this.multiFieldBatchPutCallback;
    }

    public List<Point> asSingleFieldPoints() {
        ArrayList<Point> retval = new ArrayList<Point>(this.size());
        for (AbstractPoint p : this) {
            if (!(p instanceof Point)) {
                throw new IllegalStateException("it's not a SingleFieldPoint collection");
            }
            retval.add((Point)p);
        }
        return retval;
    }

    public List<MultiFieldPoint> asMultiFieldPoints() {
        ArrayList<MultiFieldPoint> retval = new ArrayList<MultiFieldPoint>(this.size());
        for (AbstractPoint p : this) {
            if (!(p instanceof MultiFieldPoint)) {
                throw new IllegalStateException("it's not a MultiFieldPoint collection");
            }
            retval.add((MultiFieldPoint)p);
        }
        return retval;
    }

    public String toJSON() {
        SerializerFeature[] serializerFeatureArray = new SerializerFeature[3];
        serializerFeatureArray[0] = SerializerFeature.DisableCircularReferenceDetect;
        serializerFeatureArray[1] = SerializerFeature.SortField;
        serializerFeatureArray[2] = SerializerFeature.MapSortField;
        return JSON.toJSONString((Object)this, (SerializerFeature[])serializerFeatureArray);
    }
}

