/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.hitsdb.client.value.request;

import com.aliyun.hitsdb.client.value.request.MultiFieldPoint;
import com.aliyun.hitsdb.client.value.request.Point;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class UniqueUtil {
    private static final Logger LOGGER = LoggerFactory.getLogger(UniqueUtil.class);

    private static long hash(Object ... values) {
        return Arrays.hashCode(values);
    }

    static long hash(MultiFieldPoint multiFieldPoint, String field) {
        return UniqueUtil.hash(multiFieldPoint.getMetric(), multiFieldPoint.getTags(), multiFieldPoint.getTimestamp(), field);
    }

    static long hash(Point point) {
        return UniqueUtil.hash(point.getMetric(), point.getTags(), point.getTimestamp());
    }

    public static void uniqueMultiFieldPoints(Collection<MultiFieldPoint> multiFieldPointList, boolean deduplicationEnable) {
        if (!deduplicationEnable) {
            return;
        }
        try {
            HashMap checkSumToPoints = new HashMap(multiFieldPointList.size());
            Iterator<MultiFieldPoint> multiFieldPointIterator = multiFieldPointList.iterator();
            while (multiFieldPointIterator.hasNext()) {
                MultiFieldPoint multiFieldPoint = multiFieldPointIterator.next();
                Iterator<Map.Entry<String, Object>> fieldIterator = multiFieldPoint.getFields().entrySet().iterator();
                while (fieldIterator.hasNext()) {
                    Map.Entry<String, Object> field = fieldIterator.next();
                    long checksum = UniqueUtil.hash(multiFieldPoint, field.getKey());
                    if (checkSumToPoints.containsKey(checksum)) {
                        List oldPoints = (List)checkSumToPoints.get(checksum);
                        if (UniqueUtil.multiFieldPointsHasSame(oldPoints, multiFieldPoint, field.getKey())) {
                            fieldIterator.remove();
                            continue;
                        }
                        LOGGER.debug("checksum {} same but not conflict {} {} field {}", new Object[]{checksum, oldPoints, multiFieldPoint, field.getKey()});
                        oldPoints.add(multiFieldPoint);
                        continue;
                    }
                    ArrayList<MultiFieldPoint> pointList = new ArrayList<MultiFieldPoint>();
                    pointList.add(multiFieldPoint);
                    checkSumToPoints.put(checksum, pointList);
                }
                if (multiFieldPoint.getFields().size() != 0) continue;
                multiFieldPointIterator.remove();
            }
        }
        catch (Exception e) {
            LOGGER.error("ERROR occurred when uniqueMultiFieldPoints {} {}", multiFieldPointList, (Object)e);
        }
    }

    private static boolean pointsHasSame(Collection<Point> oldPoints, Point point) {
        for (Point oldPoint : oldPoints) {
            if (!UniqueUtil.pointSame(oldPoint, point)) continue;
            return true;
        }
        return false;
    }

    static boolean pointSame(Point oldPoint, Point point) {
        if (!oldPoint.getMetric().equals(point.getMetric())) {
            return false;
        }
        if (oldPoint.getTimestamp().longValue() != point.getTimestamp().longValue()) {
            return false;
        }
        if (!UniqueUtil.tagsSame(oldPoint.getTags(), point.getTags())) {
            return false;
        }
        LOGGER.info("Point {} and {} conflict", (Object)oldPoint, (Object)point);
        return true;
    }

    static boolean tagsSame(Map<String, String> oldTags, Map<String, String> tags) {
        if (oldTags.size() != tags.size()) {
            return false;
        }
        for (Map.Entry<String, String> tagKv : tags.entrySet()) {
            String tagK = tagKv.getKey();
            String tagV = tagKv.getValue();
            if (!oldTags.containsKey(tagK)) {
                return false;
            }
            if (oldTags.get(tagK).equals(tagV)) continue;
            return false;
        }
        return true;
    }

    private static boolean multiFieldPointsHasSame(Collection<MultiFieldPoint> oldPoints, MultiFieldPoint point, String field) {
        for (MultiFieldPoint oldPoint : oldPoints) {
            if (!UniqueUtil.multiFieldPointSame(oldPoint, point, field)) continue;
            return true;
        }
        return false;
    }

    static boolean multiFieldPointSame(MultiFieldPoint oldPoint, MultiFieldPoint point, String field) {
        if (!oldPoint.getFields().containsKey(field)) {
            return false;
        }
        if (!oldPoint.getMetric().equals(point.getMetric())) {
            return false;
        }
        if (oldPoint.getTimestamp().longValue() != point.getTimestamp().longValue()) {
            return false;
        }
        if (!UniqueUtil.tagsSame(oldPoint.getTags(), point.getTags())) {
            return false;
        }
        LOGGER.info("MultiFieldPoint {} and {} conflict", (Object)oldPoint, (Object)point);
        return true;
    }

    public static void uniquePoints(Collection<Point> points, boolean deduplicationEnable) {
        if (!deduplicationEnable) {
            return;
        }
        try {
            HashMap checkSumToPoints = new HashMap(points.size());
            Iterator<Point> pointIterator = points.iterator();
            while (pointIterator.hasNext()) {
                Point point = pointIterator.next();
                long checksum = UniqueUtil.hash(point);
                if (checkSumToPoints.containsKey(checksum)) {
                    List oldPoints = (List)checkSumToPoints.get(checksum);
                    if (UniqueUtil.pointsHasSame(oldPoints, point)) {
                        pointIterator.remove();
                        continue;
                    }
                    LOGGER.debug("checksum {} same but not conflict {} {}", new Object[]{checksum, oldPoints, point});
                    oldPoints.add(point);
                    continue;
                }
                ArrayList<Point> pointList = new ArrayList<Point>();
                pointList.add(point);
                checkSumToPoints.put(checksum, pointList);
            }
        }
        catch (Exception e) {
            LOGGER.error("ERROR occurred when uniquePoints {} {}", points, (Object)e);
        }
    }
}

