/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.hitsdb.client.value.response;

import com.alibaba.fastjson.annotation.JSONField;
import com.aliyun.hitsdb.client.value.JSONValue;
import com.aliyun.hitsdb.client.value.request.ByteArrayValue;
import com.aliyun.hitsdb.client.value.response.KeyValue;
import com.aliyun.hitsdb.client.value.response.QueryResultDpsSerializer;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.TreeSet;

public class QueryResult
extends JSONValue {
    private String metric;
    private Map<String, String> tags;
    private List<String> aggregateTags;
    @JSONField(serializeUsing=QueryResultDpsSerializer.class, deserializeUsing=QueryResultDpsSerializer.class)
    private LinkedHashMap<Long, Object> dps = new LinkedHashMap();
    private Class<?> type;
    @Deprecated
    private LinkedHashMap<Long, String> sdps = new LinkedHashMap();
    private static final Comparator<KeyValue> ORDER_CMP = new Comparator<KeyValue>(){

        @Override
        public int compare(KeyValue keyValue, KeyValue t1) {
            long diff = keyValue.getTimestamp() - t1.getTimestamp();
            return diff == 0L ? 0 : (diff > 0L ? 1 : -1);
        }
    };
    public static final Comparator<KeyValue> REVERSE_ORDER_CMP = new Comparator<KeyValue>(){

        @Override
        public int compare(KeyValue keyValue, KeyValue t1) {
            long diff = keyValue.getTimestamp() - t1.getTimestamp();
            return diff == 0L ? 0 : (diff > 0L ? -1 : 1);
        }
    };

    public List<KeyValue> getOrderDps() {
        return this.getOrderDps(false);
    }

    public List<KeyValue> getOrderDps(boolean reverse) {
        if (this.dps == null || this.dps.isEmpty()) {
            return Collections.emptyList();
        }
        ArrayList<KeyValue> keyValues = new ArrayList<KeyValue>(this.dps.size());
        for (Map.Entry<Long, Object> entry : this.dps.entrySet()) {
            if (entry.getValue() instanceof byte[]) {
                keyValues.add(new KeyValue(entry.getKey(), new ByteArrayValue((byte[])entry.getValue())));
                continue;
            }
            keyValues.add(new KeyValue(entry.getKey(), entry.getValue()));
        }
        if (reverse) {
            Collections.sort(keyValues, REVERSE_ORDER_CMP);
        } else {
            Collections.sort(keyValues, ORDER_CMP);
        }
        return keyValues;
    }

    public List<String> getAggregateTags() {
        return this.aggregateTags;
    }

    public void setAggregateTags(List<String> aggregateTags) {
        this.aggregateTags = aggregateTags;
    }

    public LinkedHashMap<Long, Object> getDps() {
        return this.dps;
    }

    public String getMetric() {
        return this.metric;
    }

    public Map<String, String> getTags() {
        return this.tags;
    }

    public void setDps(LinkedHashMap<Long, Object> dps) {
        this.dps = dps;
    }

    public void setMetric(String metric) {
        this.metric = metric;
    }

    public void setTags(Map<String, String> tags) {
        this.tags = tags;
    }

    public Class<?> getType() {
        return this.type;
    }

    public void setType(Class<?> type) {
        this.type = type;
    }

    @Deprecated
    public LinkedHashMap<Long, String> getSdps() {
        return this.sdps;
    }

    @Deprecated
    public void setSdps(LinkedHashMap<Long, String> sdps) {
        this.sdps = sdps;
    }

    public String tagsToString() {
        if (this.tags == null || this.tags.isEmpty()) {
            return null;
        }
        TreeSet<String> tagks = new TreeSet<String>();
        tagks.addAll(this.tags.keySet());
        StringBuilder tagsString = new StringBuilder();
        boolean firstTag = true;
        for (String tagk : tagks) {
            if (firstTag) {
                tagsString.append(tagk).append("$").append(this.tags.get(tagk));
                firstTag = false;
                continue;
            }
            tagsString.append("$").append(tagk).append("$").append(this.tags.get(tagk));
        }
        return tagsString.toString();
    }
}

