/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.appstream.model;

import com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.services.appstream.model.StorageConnector;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public class CreateStackRequest
extends AmazonWebServiceRequest
implements Serializable,
Cloneable {
    private String name;
    private String description;
    private String displayName;
    private List<StorageConnector> storageConnectors;
    private String redirectURL;
    private String feedbackURL;

    public void setName(String name) {
        this.name = name;
    }

    public String getName() {
        return this.name;
    }

    public CreateStackRequest withName(String name) {
        this.setName(name);
        return this;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public String getDescription() {
        return this.description;
    }

    public CreateStackRequest withDescription(String description) {
        this.setDescription(description);
        return this;
    }

    public void setDisplayName(String displayName) {
        this.displayName = displayName;
    }

    public String getDisplayName() {
        return this.displayName;
    }

    public CreateStackRequest withDisplayName(String displayName) {
        this.setDisplayName(displayName);
        return this;
    }

    public List<StorageConnector> getStorageConnectors() {
        return this.storageConnectors;
    }

    public void setStorageConnectors(Collection<StorageConnector> storageConnectors) {
        if (storageConnectors == null) {
            this.storageConnectors = null;
            return;
        }
        this.storageConnectors = new ArrayList<StorageConnector>(storageConnectors);
    }

    public CreateStackRequest withStorageConnectors(StorageConnector ... storageConnectors) {
        if (this.storageConnectors == null) {
            this.setStorageConnectors(new ArrayList<StorageConnector>(storageConnectors.length));
        }
        for (StorageConnector ele : storageConnectors) {
            this.storageConnectors.add(ele);
        }
        return this;
    }

    public CreateStackRequest withStorageConnectors(Collection<StorageConnector> storageConnectors) {
        this.setStorageConnectors(storageConnectors);
        return this;
    }

    public void setRedirectURL(String redirectURL) {
        this.redirectURL = redirectURL;
    }

    public String getRedirectURL() {
        return this.redirectURL;
    }

    public CreateStackRequest withRedirectURL(String redirectURL) {
        this.setRedirectURL(redirectURL);
        return this;
    }

    public void setFeedbackURL(String feedbackURL) {
        this.feedbackURL = feedbackURL;
    }

    public String getFeedbackURL() {
        return this.feedbackURL;
    }

    public CreateStackRequest withFeedbackURL(String feedbackURL) {
        this.setFeedbackURL(feedbackURL);
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getName() != null) {
            sb.append("Name: ").append(this.getName()).append(",");
        }
        if (this.getDescription() != null) {
            sb.append("Description: ").append(this.getDescription()).append(",");
        }
        if (this.getDisplayName() != null) {
            sb.append("DisplayName: ").append(this.getDisplayName()).append(",");
        }
        if (this.getStorageConnectors() != null) {
            sb.append("StorageConnectors: ").append(this.getStorageConnectors()).append(",");
        }
        if (this.getRedirectURL() != null) {
            sb.append("RedirectURL: ").append(this.getRedirectURL()).append(",");
        }
        if (this.getFeedbackURL() != null) {
            sb.append("FeedbackURL: ").append(this.getFeedbackURL());
        }
        sb.append("}");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateStackRequest)) {
            return false;
        }
        CreateStackRequest other = (CreateStackRequest)obj;
        if (other.getName() == null ^ this.getName() == null) {
            return false;
        }
        if (other.getName() != null && !other.getName().equals(this.getName())) {
            return false;
        }
        if (other.getDescription() == null ^ this.getDescription() == null) {
            return false;
        }
        if (other.getDescription() != null && !other.getDescription().equals(this.getDescription())) {
            return false;
        }
        if (other.getDisplayName() == null ^ this.getDisplayName() == null) {
            return false;
        }
        if (other.getDisplayName() != null && !other.getDisplayName().equals(this.getDisplayName())) {
            return false;
        }
        if (other.getStorageConnectors() == null ^ this.getStorageConnectors() == null) {
            return false;
        }
        if (other.getStorageConnectors() != null && !other.getStorageConnectors().equals(this.getStorageConnectors())) {
            return false;
        }
        if (other.getRedirectURL() == null ^ this.getRedirectURL() == null) {
            return false;
        }
        if (other.getRedirectURL() != null && !other.getRedirectURL().equals(this.getRedirectURL())) {
            return false;
        }
        if (other.getFeedbackURL() == null ^ this.getFeedbackURL() == null) {
            return false;
        }
        return other.getFeedbackURL() == null || other.getFeedbackURL().equals(this.getFeedbackURL());
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getName() == null ? 0 : this.getName().hashCode());
        hashCode = 31 * hashCode + (this.getDescription() == null ? 0 : this.getDescription().hashCode());
        hashCode = 31 * hashCode + (this.getDisplayName() == null ? 0 : this.getDisplayName().hashCode());
        hashCode = 31 * hashCode + (this.getStorageConnectors() == null ? 0 : this.getStorageConnectors().hashCode());
        hashCode = 31 * hashCode + (this.getRedirectURL() == null ? 0 : this.getRedirectURL().hashCode());
        hashCode = 31 * hashCode + (this.getFeedbackURL() == null ? 0 : this.getFeedbackURL().hashCode());
        return hashCode;
    }

    public CreateStackRequest clone() {
        return (CreateStackRequest)super.clone();
    }
}

