/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.appstream.model;

import com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.services.appstream.model.StackAttribute;
import com.amazonaws.services.appstream.model.StorageConnector;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public class UpdateStackRequest
extends AmazonWebServiceRequest
implements Serializable,
Cloneable {
    private String displayName;
    private String description;
    private String name;
    private List<StorageConnector> storageConnectors;
    @Deprecated
    private Boolean deleteStorageConnectors;
    private String redirectURL;
    private String feedbackURL;
    private List<String> attributesToDelete;

    public void setDisplayName(String displayName) {
        this.displayName = displayName;
    }

    public String getDisplayName() {
        return this.displayName;
    }

    public UpdateStackRequest withDisplayName(String displayName) {
        this.setDisplayName(displayName);
        return this;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public String getDescription() {
        return this.description;
    }

    public UpdateStackRequest withDescription(String description) {
        this.setDescription(description);
        return this;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getName() {
        return this.name;
    }

    public UpdateStackRequest withName(String name) {
        this.setName(name);
        return this;
    }

    public List<StorageConnector> getStorageConnectors() {
        return this.storageConnectors;
    }

    public void setStorageConnectors(Collection<StorageConnector> storageConnectors) {
        if (storageConnectors == null) {
            this.storageConnectors = null;
            return;
        }
        this.storageConnectors = new ArrayList<StorageConnector>(storageConnectors);
    }

    public UpdateStackRequest withStorageConnectors(StorageConnector ... storageConnectors) {
        if (this.storageConnectors == null) {
            this.setStorageConnectors(new ArrayList<StorageConnector>(storageConnectors.length));
        }
        for (StorageConnector ele : storageConnectors) {
            this.storageConnectors.add(ele);
        }
        return this;
    }

    public UpdateStackRequest withStorageConnectors(Collection<StorageConnector> storageConnectors) {
        this.setStorageConnectors(storageConnectors);
        return this;
    }

    @Deprecated
    public void setDeleteStorageConnectors(Boolean deleteStorageConnectors) {
        this.deleteStorageConnectors = deleteStorageConnectors;
    }

    @Deprecated
    public Boolean getDeleteStorageConnectors() {
        return this.deleteStorageConnectors;
    }

    @Deprecated
    public UpdateStackRequest withDeleteStorageConnectors(Boolean deleteStorageConnectors) {
        this.setDeleteStorageConnectors(deleteStorageConnectors);
        return this;
    }

    @Deprecated
    public Boolean isDeleteStorageConnectors() {
        return this.deleteStorageConnectors;
    }

    public void setRedirectURL(String redirectURL) {
        this.redirectURL = redirectURL;
    }

    public String getRedirectURL() {
        return this.redirectURL;
    }

    public UpdateStackRequest withRedirectURL(String redirectURL) {
        this.setRedirectURL(redirectURL);
        return this;
    }

    public void setFeedbackURL(String feedbackURL) {
        this.feedbackURL = feedbackURL;
    }

    public String getFeedbackURL() {
        return this.feedbackURL;
    }

    public UpdateStackRequest withFeedbackURL(String feedbackURL) {
        this.setFeedbackURL(feedbackURL);
        return this;
    }

    public List<String> getAttributesToDelete() {
        return this.attributesToDelete;
    }

    public void setAttributesToDelete(Collection<String> attributesToDelete) {
        if (attributesToDelete == null) {
            this.attributesToDelete = null;
            return;
        }
        this.attributesToDelete = new ArrayList<String>(attributesToDelete);
    }

    public UpdateStackRequest withAttributesToDelete(String ... attributesToDelete) {
        if (this.attributesToDelete == null) {
            this.setAttributesToDelete(new ArrayList<String>(attributesToDelete.length));
        }
        for (String ele : attributesToDelete) {
            this.attributesToDelete.add(ele);
        }
        return this;
    }

    public UpdateStackRequest withAttributesToDelete(Collection<String> attributesToDelete) {
        this.setAttributesToDelete(attributesToDelete);
        return this;
    }

    public UpdateStackRequest withAttributesToDelete(StackAttribute ... attributesToDelete) {
        ArrayList<String> attributesToDeleteCopy = new ArrayList<String>(attributesToDelete.length);
        for (StackAttribute value : attributesToDelete) {
            attributesToDeleteCopy.add(value.toString());
        }
        if (this.getAttributesToDelete() == null) {
            this.setAttributesToDelete(attributesToDeleteCopy);
        } else {
            this.getAttributesToDelete().addAll(attributesToDeleteCopy);
        }
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getDisplayName() != null) {
            sb.append("DisplayName: ").append(this.getDisplayName()).append(",");
        }
        if (this.getDescription() != null) {
            sb.append("Description: ").append(this.getDescription()).append(",");
        }
        if (this.getName() != null) {
            sb.append("Name: ").append(this.getName()).append(",");
        }
        if (this.getStorageConnectors() != null) {
            sb.append("StorageConnectors: ").append(this.getStorageConnectors()).append(",");
        }
        if (this.getDeleteStorageConnectors() != null) {
            sb.append("DeleteStorageConnectors: ").append(this.getDeleteStorageConnectors()).append(",");
        }
        if (this.getRedirectURL() != null) {
            sb.append("RedirectURL: ").append(this.getRedirectURL()).append(",");
        }
        if (this.getFeedbackURL() != null) {
            sb.append("FeedbackURL: ").append(this.getFeedbackURL()).append(",");
        }
        if (this.getAttributesToDelete() != null) {
            sb.append("AttributesToDelete: ").append(this.getAttributesToDelete());
        }
        sb.append("}");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UpdateStackRequest)) {
            return false;
        }
        UpdateStackRequest other = (UpdateStackRequest)obj;
        if (other.getDisplayName() == null ^ this.getDisplayName() == null) {
            return false;
        }
        if (other.getDisplayName() != null && !other.getDisplayName().equals(this.getDisplayName())) {
            return false;
        }
        if (other.getDescription() == null ^ this.getDescription() == null) {
            return false;
        }
        if (other.getDescription() != null && !other.getDescription().equals(this.getDescription())) {
            return false;
        }
        if (other.getName() == null ^ this.getName() == null) {
            return false;
        }
        if (other.getName() != null && !other.getName().equals(this.getName())) {
            return false;
        }
        if (other.getStorageConnectors() == null ^ this.getStorageConnectors() == null) {
            return false;
        }
        if (other.getStorageConnectors() != null && !other.getStorageConnectors().equals(this.getStorageConnectors())) {
            return false;
        }
        if (other.getDeleteStorageConnectors() == null ^ this.getDeleteStorageConnectors() == null) {
            return false;
        }
        if (other.getDeleteStorageConnectors() != null && !other.getDeleteStorageConnectors().equals(this.getDeleteStorageConnectors())) {
            return false;
        }
        if (other.getRedirectURL() == null ^ this.getRedirectURL() == null) {
            return false;
        }
        if (other.getRedirectURL() != null && !other.getRedirectURL().equals(this.getRedirectURL())) {
            return false;
        }
        if (other.getFeedbackURL() == null ^ this.getFeedbackURL() == null) {
            return false;
        }
        if (other.getFeedbackURL() != null && !other.getFeedbackURL().equals(this.getFeedbackURL())) {
            return false;
        }
        if (other.getAttributesToDelete() == null ^ this.getAttributesToDelete() == null) {
            return false;
        }
        return other.getAttributesToDelete() == null || other.getAttributesToDelete().equals(this.getAttributesToDelete());
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getDisplayName() == null ? 0 : this.getDisplayName().hashCode());
        hashCode = 31 * hashCode + (this.getDescription() == null ? 0 : this.getDescription().hashCode());
        hashCode = 31 * hashCode + (this.getName() == null ? 0 : this.getName().hashCode());
        hashCode = 31 * hashCode + (this.getStorageConnectors() == null ? 0 : this.getStorageConnectors().hashCode());
        hashCode = 31 * hashCode + (this.getDeleteStorageConnectors() == null ? 0 : this.getDeleteStorageConnectors().hashCode());
        hashCode = 31 * hashCode + (this.getRedirectURL() == null ? 0 : this.getRedirectURL().hashCode());
        hashCode = 31 * hashCode + (this.getFeedbackURL() == null ? 0 : this.getFeedbackURL().hashCode());
        hashCode = 31 * hashCode + (this.getAttributesToDelete() == null ? 0 : this.getAttributesToDelete().hashCode());
        return hashCode;
    }

    public UpdateStackRequest clone() {
        return (UpdateStackRequest)super.clone();
    }
}

